resource "aws_sns_topic" "edge_list_request_topic" {
  name = "${var.environment}_edge_list_request"
}

resource "aws_sns_topic" "edge_get_request_topic" {
  name = "${var.environment}_edge_get_request"
}

resource "aws_sns_topic" "edge_count_request_topic" {
  name = "${var.environment}_edge_count_request"
}

resource "aws_sns_topic" "invalidate_cache_topic" {
  name = "${var.environment}_invalidate_cache"
}

# This policy defines the AWS accounts that may subscribe to this topic.
data "aws_iam_policy_document" "edge_list_request_topic_role_policy" {
  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccounts"

    principals {
      type        = "AWS"
      identifiers = "${var.sns_can_subscribe_accounts}"
    }

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
      "SNS:ListSubscriptionsByTopic",
    ]

    resources = [
      "${aws_sns_topic.edge_list_request_topic.arn}",
    ]
  }
}

resource "aws_sns_topic_policy" "edge_list_request_topic_policy" {
  arn    = "${aws_sns_topic.edge_list_request_topic.arn}"
  policy = "${data.aws_iam_policy_document.edge_list_request_topic_role_policy.json}"
}

# This policy defines the AWS accounts that may subscribe to this topic.
data "aws_iam_policy_document" "edge_get_request_topic_role_policy" {
  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccounts"

    principals {
      type        = "AWS"
      identifiers = "${var.sns_can_subscribe_accounts}"
    }

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
      "SNS:ListSubscriptionsByTopic",
    ]

    resources = [
      "${aws_sns_topic.edge_get_request_topic.arn}",
    ]
  }
}

resource "aws_sns_topic_policy" "edge_get_request_topic_policy" {
  arn    = "${aws_sns_topic.edge_get_request_topic.arn}"
  policy = "${data.aws_iam_policy_document.edge_get_request_topic_role_policy.json}"
}

# This policy defines the AWS accounts that may subscribe to this topic.
data "aws_iam_policy_document" "edge_count_request_topic_role_policy" {
  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccounts"

    principals {
      type        = "AWS"
      identifiers = "${var.sns_can_subscribe_accounts}"
    }

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
      "SNS:ListSubscriptionsByTopic",
    ]

    resources = [
      "${aws_sns_topic.edge_count_request_topic.arn}",
    ]
  }
}

resource "aws_sns_topic_policy" "edge_count_request_topic_policy" {
  arn    = "${aws_sns_topic.edge_count_request_topic.arn}"
  policy = "${data.aws_iam_policy_document.edge_count_request_topic_role_policy.json}"
}

# This policy defines the AWS accounts that may subscribe to this topic.
data "aws_iam_policy_document" "invalidate_cache_topic_role_policy" {
  statement {
    sid = "AllowSubscriptionsFromOtherTwitchAWSAccounts"

    principals {
      type        = "AWS"
      identifiers = "${var.sns_can_subscribe_accounts}"
    }

    actions = [
      "SNS:Subscribe",
      "SNS:Receive",
      "SNS:ListSubscriptionsByTopic",
    ]

    resources = [
      "${aws_sns_topic.invalidate_cache_topic.arn}",
    ]
  }
}

resource "aws_sns_topic_policy" "invalidate_cache_topic_policy" {
  arn    = "${aws_sns_topic.invalidate_cache_topic.arn}"
  policy = "${data.aws_iam_policy_document.invalidate_cache_topic_role_policy.json}"
}
