package comparison

import (
	"strconv"
)

type ComparableArray struct {
	internalValue []ComparableResults

	progressIndex int
}

func (self *ComparableArray) ResetResults() {
	self.progressIndex = 0
	for _, value := range self.internalValue {
		value.ResetResults()
	}
}

func (self *ComparableArray) NextResultFromPath(path []string) interface{} {
	if len(path) == 0 {
		return self.internalValue
	}

	nextSegment := path[0]
	remainingSegments := path[1:]

	retIndex := -1
	if nextSegment == "*" {
		retIndex = self.progressIndex

		if len(remainingSegments) > 0 {
			self.progressIndex++
		}
	} else {
		var err error
		retIndex, err = strconv.Atoi(nextSegment)
		if err != nil {
			return nil
		}
	}

	if retIndex < 0 || retIndex >= len(self.internalValue) {
		return nil
	}

	indexedValue := self.internalValue[retIndex]
	if indexedValue == nil {
		return indexedValue
	}

	retVal := indexedValue.NextResultFromPath(remainingSegments)
	if len(remainingSegments) == 0 {
		self.internalValue = append(self.internalValue[:retIndex], self.internalValue[retIndex+1:]...)
	}

	return retVal
}
