package comparison

import (
	"log"

	"github.com/luci/go-render/render"
)

type LogLevel int

const (
	NoLog    = iota
	LightLog = iota
	FullLog  = iota
)

func LogMismatch(methodName string, params interface{}, old interface{}, new interface{}, logLevel LogLevel) {
	if logLevel < 1 {
		return
	} else if logLevel == 1 {
		log.Printf("Mismatch on call to %s with params %s: %v => %v\n", methodName, render.Render(params), old, new)
	} else {
		log.Printf("Mismatch on call to %s with params %s: %s => %s\n", methodName, render.Render(params), render.Render(old), render.Render(new))
	}
}
