# rlimit

Package rlimit exposes a `Var()` method that can be used to report values returned buy getrlimit(2) as expvar metrics.

Here is example output from graphdb running locally:

## Usage

~~~go
  // This is how rlimit is integrated into graphdb.
	f.serviceCommon.ExpvarHandler.Exported["rlimit"] = rlimit.Var()
~~~

## Example Output
~~~sh
{
  "rlimit": {
    "no_file": {
      "Cur": 4864,
      "Max": 9223372036854776000
    },
    "stack": {
      "Cur": 67104768,
      "Max": 67104768
    },
    "core": {
      "Cur": 0,
      "Max": 9223372036854776000
    },
    "cpu": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    },
    "file_size": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    },
    "data": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    },
    "as": {
      "Cur": 9223372036854776000,
      "Max": 9223372036854776000
    }
  }
}
~~~
