package v2

import (
	"code.justin.tv/web/cohesion/api/v2/internal/utils"
	"code.justin.tv/web/cohesion/rpc"

	"golang.org/x/net/context"
)

// Count is an operation that returns a response with the count for the
// association in the request
func (c *CohesionServer) Count(ctx context.Context, in *rpc.RequestV2) (*rpc.CountResponseV2, error) {
	timer := utils.NewTimer(c, "v2.count", in.Source)
	err := timer.Start(ctx, in.Options)
	defer timer.End()
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	out := new(rpc.CountResponseV2)
	assoc, err := utils.MakeCohesionAssociation(in.Associations[0])
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	count, err := c.backend.CountAssoc(timer.Ctx, assoc.E1, assoc.Kind, assoc.E2.Kind)
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	out.Count = int64(count)
	return out, nil
}
