package v2

import (
	"code.justin.tv/web/cohesion/api/v2/internal/utils"
	"code.justin.tv/web/cohesion/associations"
	"code.justin.tv/web/cohesion/rpc"

	"golang.org/x/net/context"
	"google.golang.org/grpc/codes"
)

// Create is an operation that creates the association in the request
// An empty response is returned.
func (c *CohesionServer) Create(ctx context.Context, in *rpc.RequestV2) (*rpc.EmptyResponseV2, error) {
	timer := utils.NewTimer(c, "v2.create", in.Source)
	err := timer.Start(ctx, in.Options)
	defer timer.End()
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	out := new(rpc.EmptyResponseV2)
	assoc, err := utils.MakeCohesionAssociation(in.Associations[0])
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	err = c.backend.CreateAssoc(timer.Ctx, assoc)
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		if _, ok := err.(associations.ErrAssociationExists); ok {
			return nil, errf(codes.AlreadyExists, "%s", err.Error())
		}
		return nil, err
	}

	return out, nil
}
