package v2

import (
	"code.justin.tv/web/cohesion/api/v2/internal/utils"
	"code.justin.tv/web/cohesion/associations"
	"code.justin.tv/web/cohesion/rpc"

	"golang.org/x/net/context"
	"google.golang.org/grpc/codes"
)

// Delete is an operation that deletes the associations in the request
// An empty response is returned
func (c *CohesionServer) Delete(ctx context.Context, in *rpc.RequestV2) (*rpc.EmptyResponseV2, error) {
	out := new(rpc.EmptyResponseV2)
	assoc, err := utils.MakeCohesionAssociation(in.Associations[0])
	if err != nil {
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	var timer *utils.Timer
	if assoc.E2.ID == "" {
		timer = utils.NewTimer(c, "v2.bulk_delete", in.Source)
	} else {
		timer = utils.NewTimer(c, "v2.delete", in.Source)
	}
	err = timer.Start(ctx, in.Options)
	defer timer.End()
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	err = c.backend.DeleteAssoc(timer.Ctx, assoc)
	if err != nil {
		if _, ok := err.(associations.ErrNotFound); ok {
			return nil, errf(codes.NotFound, "%s", err.Error())
		}
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	return out, nil
}
