package v2

import (
	"code.justin.tv/web/cohesion/api/v2/internal/utils"
	"code.justin.tv/web/cohesion/rpc"
	"golang.org/x/net/context"
)

// Get is an operation that returns a list of responses depending on the
// associations requested
func (c *CohesionServer) GetHitCounts(ctx context.Context, in *rpc.HitCountRequestV2) (*rpc.HitCountResponseV2, error) {
	out := new(rpc.HitCountResponseV2)

	var timer *utils.Timer
	timer = utils.NewTimer(c, "v2.getHitCounts", in.Source)
	err := timer.Start(ctx, nil)
	defer timer.End()
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	hitCounts, err := c.backend.GetHitCounts(timer.Ctx, in.Client, int(in.Minutes))

	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	elements := []*rpc.HitCountElement{}

	for k, v := range hitCounts {
		element := &rpc.HitCountElement{
			Client:    k,
			HitCounts: int64(v),
		}
		elements = append(elements, element)
	}

	out.HitCounts = elements

	return out, nil
}
