package utils

import (
	"time"

	"code.justin.tv/web/cohesion/associations"
	"code.justin.tv/web/cohesion/backend"
	"code.justin.tv/web/cohesion/clients"
	"code.justin.tv/web/cohesion/datastore/testds"
	"github.com/cactus/go-statsd-client/statsd"
)

var statsdSampleRate float32 = 0.1

func init() {
	associations.InitTestSchema()
}

type testAPI struct {
	backend     backend.Backender
	stats       statsd.Statter
	errorLogger clients.ErrorLogger
}

func (T *testAPI) Backend() backend.Backender {
	return T.backend
}

func (T *testAPI) Stats() statsd.Statter {
	return T.stats
}

func (T *testAPI) ErrorLogger() clients.ErrorLogger {
	return T.errorLogger
}

func makeTestDSBackend(health bool, t time.Time) *testds.Backend {
	return testds.New(health, t)
}

func makeBackend(ds *testds.Backend) backend.Backender {
	client, _ := statsd.NewNoopClient()
	be := backend.New(client)
	be.Writer = ds
	be.Reader = ds
	return be
}

func withUnhealthyBackend(t time.Time, w func(router API)) func() {
	return func() {
		w(&testAPI{backend: makeBackend(makeTestDSBackend(false, t))})
	}
}

func withHealthyBackend(t time.Time, w func(router API)) func() {
	return func() {
		w(&testAPI{backend: makeBackend(makeTestDSBackend(true, t))})
	}
}
