package utils

import (
	"encoding/json"
	"reflect"
	"strings"

	"code.justin.tv/web/cohesion/associations"
	"code.justin.tv/web/cohesion/backend"
)

func extractSvcnameError(err error) string {
	t := reflect.TypeOf(err)
	if t.PkgPath() == "" {
		return ""
	}
	return t.PkgPath() + "/" + t.Name()
}

func extractRepoFromSvcname(svcname string) string {
	if svcname != "" {
		svcname = strings.Replace(svcname, "code.justin.tv/", "", -1)
		svcname = strings.Replace(svcname, "/", "-", -1)
	} else {
		svcname = "unknown"
	}

	return svcname
}

func extractData(b []byte) (map[string]interface{}, error) {
	var err error

	data := make(map[string]interface{})
	if len(b) > 0 {
		err = json.Unmarshal(b, &data)
	}
	return data, err
}

// ExtractUpdateParams takes in a map and extracts 'data_bag' and
// 'new_assoc_kind' and creates an UpdateParams struct with the 'data_bag' and
// 'new_assoc_kind'
func ExtractUpdateParams(blob map[string]interface{}) (*backend.UpdateParams, error) {
	var err error
	data := map[string]interface{}{}
	assocKind := associations.SchemaManager.UnknownAssocKind

	if v, ok := blob["data_bag"]; ok {
		bytes, err := json.Marshal(v)
		if err != nil {
			return backend.NewUpdateParams(data, assocKind), err
		}

		data, err = extractData(bytes)
		if err != nil {
			return backend.NewUpdateParams(data, assocKind), err
		}
	}

	if v, ok := blob["new_assoc_kind"]; ok {
		if ak, ok := v.(string); ok {
			assocKind, _ = associations.SchemaManager.AssocKind(ak)
		}
	}

	return backend.NewUpdateParams(data, assocKind), err
}
