package v2

import (
	"code.justin.tv/web/cohesion/api/v2/internal/utils"
	"code.justin.tv/web/cohesion/associations"
	"code.justin.tv/web/cohesion/backend"
	"code.justin.tv/web/cohesion/rpc"

	"golang.org/x/net/context"
	"google.golang.org/grpc/codes"
)

// Update is an operation that updates the associations in the request
// An empty response is returned
func (c *CohesionServer) Update(ctx context.Context, in *rpc.RequestV2) (*rpc.EmptyResponseV2, error) {
	out := new(rpc.EmptyResponseV2)
	assocs, err := utils.MakeCohesionAssociations(in.Associations)
	if err != nil {
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	var timer *utils.Timer
	if len(assocs) > 1 {
		timer = utils.NewTimer(c, "v2.batch_update", in.Source)
	} else if assocs[0].E2.ID == "" {
		timer = utils.NewTimer(c, "v2.bulk_update", in.Source)
	} else {
		timer = utils.NewTimer(c, "v2.update", in.Source)
	}
	err = timer.Start(ctx, in.Options)
	defer timer.End()
	if err != nil {
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	var updateParams *backend.UpdateParams
	if len(assocs) > 1 {
		_, err = c.backend.BatchUpdateAssoc(timer.Ctx, assocs...)
	} else {
		updateParams, err = utils.ExtractUpdateParams(assocs[0].D)
		if err != nil {
			timer.Err = err
			utils.LogError(c, in.Source, err)
			return nil, err
		}

		err = c.backend.UpdateAssoc(timer.Ctx, assocs[0], updateParams)
	}

	if err != nil {
		if _, ok := err.(associations.ErrNotFound); ok {
			return nil, errf(codes.NotFound, "%s", err.Error())
		}
		timer.Err = err
		utils.LogError(c, in.Source, err)
		return nil, err
	}

	return out, nil
}
