package backend

import (
	"fmt"

	"code.justin.tv/web/cohesion/associations"
)

// Operation contains the necessary information to perform an operation in the
// backend package
type Operation struct {
	Assoc     associations.Association
	Operation string
	Params    *UpdateParams
}

// NewOperation creates a new Operation struct
func NewOperation(assoc associations.Association, operation string, params *UpdateParams) Operation {
	return Operation{
		Assoc:     assoc,
		Operation: operation,
		Params:    params,
	}
}

// ErrFailedOperation is an error to indicate that an operation has failed
type ErrFailedOperation struct {
	Operation string
	Message   string
}

func (T ErrFailedOperation) Error() string {
	return fmt.Sprintf("Operation %s has failed: %s", T.Operation, T.Message)
}
