package v2

import "golang.org/x/net/context"

func (c *v2Client) Count(ctx context.Context, from Entity, kind string, bulkKind string) (int, error) {
	request, err := c.newBulkRequest(from, kind, bulkKind, nil)
	if err != nil {
		return 0, err
	}

	resp, err := c.conn.Count(ctx, request)
	if err != nil {
		return 0, err
	}

	// This casting could be dangerous
	return int(resp.Count), nil
}
