package v2

import (
	"code.justin.tv/web/cohesion/associations"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
)

func (c *v2Client) Delete(ctx context.Context, from Entity, kind string, to Entity) error {
	request, err := c.newRequest(from, kind, to, nil)
	if err != nil {
		return err
	}

	_, err = c.conn.Delete(ctx, request)
	if err != nil && grpc.Code(err) == codes.NotFound {
		err = associations.ErrNotFound{}
	}

	return err
}

func (c *v2Client) BulkDelete(ctx context.Context, from Entity, kind string, bulkKind string) error {
	request, err := c.newBulkRequest(from, kind, bulkKind, nil)
	if err != nil {
		return err
	}

	_, err = c.conn.Delete(ctx, request)
	if err != nil && grpc.Code(err) == codes.NotFound {
		err = associations.ErrNotFound{}
	}

	return err
}
