// Generated by: main
// TypeWriter: migrationsecondary
// Directive: +gen on HealthReporterReader

package datastore

import (
	"time"

	"code.justin.tv/d8a/migration"
	"code.justin.tv/d8a/migration/comparison"
	"code.justin.tv/web/cohesion/associations"
	"golang.org/x/net/context"
)

//CreateHealthReporterReaderSecondary is a method that builds a decorator for a HealthReporterReader object which mirrors calls
//to a map of secondary HealthReporterReader objects and compares results and timings.
func CreateHealthReporterReaderSecondary(inner HealthReporterReader, statsdHostPort string, logLevel comparison.LogLevel, preprocessor comparison.ComparePreprocessor, environment string, repo string,
	errCheck migration.ErrorCheck, secondaries map[string]Reader) HealthReporterReader {

	return &secondary_HealthReporterReader{
		inner:        inner,
		callComparer: migration.CreateCallComparer(statsdHostPort, logLevel, preprocessor, environment, repo, "HealthReporterReader"),
		secondaries:  secondaries,
		errCheck:     errCheck,
	}
}

type secondary_HealthReporterReader struct {
	inner        HealthReporterReader
	callComparer migration.CallComparer
	secondaries  map[string]Reader
	errCheck     migration.ErrorCheck
}

//BulkGetAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterReader) BulkGetAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.EntityKind,
	param5 SortBy,
	param6 int,
	param7 int,
	param8 string,
) ([]*associations.AssocResponse, error) {

	begin := time.Now()

	//Call method on inner backend
	retVal1, retVal2 := self.inner.BulkGetAssoc(param1,
		param2,
		param3,
		param4,
		param5,
		param6,
		param7,
		param8,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		return retVal1, retVal2
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("BulkGetAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Reader) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("BulkGetAssoc", secName, duration,
				[]interface{}{param2, param3, param4, param5, param6, param7, param8}, []interface{}{retVal1, retVal2}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1, secondaryRetVal2 := sec.BulkGetAssoc(ctx,
						param2,
						param3,
						param4,
						param5,
						param6,
						param7,
						param8,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal2 != nil && self.errCheck.SeriousError(secondaryRetVal2) {
						return []interface{}{}, secondaryRetVal2
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1, secondaryRetVal2}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1, retVal2
}

//CountAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterReader) CountAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.EntityKind,
) (int, error) {

	begin := time.Now()

	//Call method on inner backend
	retVal1, retVal2 := self.inner.CountAssoc(param1,
		param2,
		param3,
		param4,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		return retVal1, retVal2
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("CountAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Reader) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("CountAssoc", secName, duration,
				[]interface{}{param2, param3, param4}, []interface{}{retVal1, retVal2}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1, secondaryRetVal2 := sec.CountAssoc(ctx,
						param2,
						param3,
						param4,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal2 != nil && self.errCheck.SeriousError(secondaryRetVal2) {
						return []interface{}{}, secondaryRetVal2
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1, secondaryRetVal2}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1, retVal2
}

//GetAllAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterReader) GetAllAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.Entity,
) ([]*associations.AssocResponseWithMeta, error) {

	begin := time.Now()

	//Call method on inner backend
	retVal1, retVal2 := self.inner.GetAllAssoc(param1,
		param2,
		param3,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		return retVal1, retVal2
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("GetAllAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Reader) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("GetAllAssoc", secName, duration,
				[]interface{}{param2, param3}, []interface{}{retVal1, retVal2}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1, secondaryRetVal2 := sec.GetAllAssoc(ctx,
						param2,
						param3,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal2 != nil && self.errCheck.SeriousError(secondaryRetVal2) {
						return []interface{}{}, secondaryRetVal2
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1, secondaryRetVal2}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1, retVal2
}

//GetAllAssocBatch is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterReader) GetAllAssocBatch(param1 context.Context,
	param2 []associations.Association,
) ([]*associations.AssocResponseWithMeta, error) {

	begin := time.Now()

	//Call method on inner backend
	retVal1, retVal2 := self.inner.GetAllAssocBatch(param1,
		param2,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		return retVal1, retVal2
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("GetAllAssocBatch", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Reader) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("GetAllAssocBatch", secName, duration,
				[]interface{}{param2}, []interface{}{retVal1, retVal2}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1, secondaryRetVal2 := sec.GetAllAssocBatch(ctx,
						param2,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal2 != nil && self.errCheck.SeriousError(secondaryRetVal2) {
						return []interface{}{}, secondaryRetVal2
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1, secondaryRetVal2}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1, retVal2
}

//GetAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterReader) GetAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.Entity,
) ([]*associations.AssocResponse, error) {

	begin := time.Now()

	//Call method on inner backend
	retVal1, retVal2 := self.inner.GetAssoc(param1,
		param2,
		param3,
		param4,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		return retVal1, retVal2
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("GetAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Reader) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("GetAssoc", secName, duration,
				[]interface{}{param2, param3, param4}, []interface{}{retVal1, retVal2}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1, secondaryRetVal2 := sec.GetAssoc(ctx,
						param2,
						param3,
						param4,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal2 != nil && self.errCheck.SeriousError(secondaryRetVal2) {
						return []interface{}{}, secondaryRetVal2
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1, secondaryRetVal2}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1, retVal2
}

func (self *secondary_HealthReporterReader) GetHitCounts(ctx context.Context, client string, minutes int) (map[string]int, error) {
	// TODO - this only reads the primary - perhaps add some logic for the secondary - but not critical
	return self.inner.GetHitCounts(ctx, client, minutes)
}

//Health is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterReader) Health(param1 context.Context,
) error {

	//Call method on inner backend
	retVal1 := self.inner.Health(param1)

	return retVal1
}

//Name is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterReader) Name() string {

	//Call method on inner backend
	retVal1 := self.inner.Name()

	return retVal1
}

//SetName is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterReader) SetName(param1 string,
) {

	//Call method on inner backend
	self.inner.SetName(param1)

	return
}

//Utilization is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterReader) Utilization(param1 context.Context,
) float32 {

	//Call method on inner backend
	retVal1 := self.inner.Utilization(param1)

	return retVal1
}
