// Generated by: main
// TypeWriter: migrationconsumer
// Directive: +gen on HealthReporterWriter

package datastore

import (
	"encoding/json"
	"fmt"
	"log"
	"time"

	"code.justin.tv/d8a/migration"
	"code.justin.tv/d8a/migration/comparison"
	"code.justin.tv/web/cohesion/associations"
	"golang.org/x/net/context"
)

//CreateHealthReporterWriterConsumer is a method that builds a replayer that writes to a HealthReporterWriter object from
//kinesis.
func CreateHealthReporterWriterConsumer(inner HealthReporterWriter, logLevel comparison.LogLevel, comparePreprocessor comparison.ComparePreprocessor, errCheck migration.ErrorCheck) migration.Replayer {
	return &consumer_HealthReporterWriter{
		inner:               inner,
		logLevel:            logLevel,
		comparePreprocessor: comparePreprocessor,
		errCheck:            errCheck,
	}
}

type consumer_HealthReporterWriter struct {
	inner               HealthReporterWriter
	errCheck            migration.ErrorCheck
	logLevel            comparison.LogLevel
	comparePreprocessor comparison.ComparePreprocessor
}

//InterfaceName returns the name to use in stats & other places
func (self *consumer_HealthReporterWriter) InterfaceName() string {
	return "HealthReporterWriter"
}

func (self *consumer_HealthReporterWriter) LogLevel() comparison.LogLevel {
	return self.logLevel
}

func (self *consumer_HealthReporterWriter) ComparePreprocessor() comparison.ComparePreprocessor {
	return self.comparePreprocessor
}

//ReplayCall receives a context, method name, and serialized kinesis record and replays the call that caused
//the kinesis record to be written.  It will then return the original and replay call results so that they
//can be compared.
func (self *consumer_HealthReporterWriter) ReplayCall(context context.Context, methodName string, json []byte) ([]interface{}, error) {
	switch methodName {
	case "BatchUpdateAssoc":
		{
			//Replay a BatchUpdateAssoc call
			return self.ReplayBatchUpdateAssocCall(context, json)
		}
	case "BulkDeleteAssoc":
		{
			//Replay a BulkDeleteAssoc call
			return self.ReplayBulkDeleteAssocCall(context, json)
		}
	case "BulkUpdateAssoc":
		{
			//Replay a BulkUpdateAssoc call
			return self.ReplayBulkUpdateAssocCall(context, json)
		}
	case "CreateAssoc":
		{
			//Replay a CreateAssoc call
			return self.ReplayCreateAssocCall(context, json)
		}
	case "DeleteAssoc":
		{
			//Replay a DeleteAssoc call
			return self.ReplayDeleteAssocCall(context, json)
		}
	case "UpdateAssoc":
		{
			//Replay a UpdateAssoc call
			return self.ReplayUpdateAssocCall(context, json)
		}
	default:
		{
			return []interface{}{}, fmt.Errorf("Unknown method 'HealthReporterWriter.%s'- has the interface definition changed?", methodName)
		}
	}
}

//HealthReporterWriterBatchUpdateAssocMessage represents a deserialized kinesis replay record
//for the BatchUpdateAssoc method
type HealthReporterWriterBatchUpdateAssocMessage struct {
	Param_param2 []associations.Association
}

func (self *consumer_HealthReporterWriter) ReplayBatchUpdateAssocCall(context context.Context, jsonData []byte) (newResults []interface{}, err error) {

	//Initialize old & new results, and the value to deserialize to
	newResults = []interface{}{}
	deserializedMessage := HealthReporterWriterBatchUpdateAssocMessage{}

	//Deserialize kinesis record to struct
	err = json.Unmarshal(jsonData, &deserializedMessage)
	if err != nil {
		log.Fatalln(err)
		return
	}

	//Replay
	retVal1, retVal2 := self.inner.BatchUpdateAssoc(context,
		deserializedMessage.Param_param2,
	)

	//Bail if the replay had a serious error
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		err = retVal2
		return
	}

	//If the replay worked out, record the results
	newResults = []interface{}{retVal1, retVal2}
	return
}

//HealthReporterWriterBulkDeleteAssocMessage represents a deserialized kinesis replay record
//for the BulkDeleteAssoc method
type HealthReporterWriterBulkDeleteAssocMessage struct {
	Param_param2 associations.Entity
	Param_param3 associations.AssocKind
	Param_param4 associations.EntityKind
}

func (self *consumer_HealthReporterWriter) ReplayBulkDeleteAssocCall(context context.Context, jsonData []byte) (newResults []interface{}, err error) {

	//Initialize old & new results, and the value to deserialize to
	newResults = []interface{}{}
	deserializedMessage := HealthReporterWriterBulkDeleteAssocMessage{}

	//Deserialize kinesis record to struct
	err = json.Unmarshal(jsonData, &deserializedMessage)
	if err != nil {
		log.Fatalln(err)
		return
	}

	//Replay
	retVal1 := self.inner.BulkDeleteAssoc(context,
		deserializedMessage.Param_param2,
		deserializedMessage.Param_param3,
		deserializedMessage.Param_param4,
	)

	//Bail if the replay had a serious error
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		err = retVal1
		return
	}

	//If the replay worked out, record the results
	newResults = []interface{}{retVal1}
	return
}

//HealthReporterWriterBulkUpdateAssocMessage represents a deserialized kinesis replay record
//for the BulkUpdateAssoc method
type HealthReporterWriterBulkUpdateAssocMessage struct {
	Param_param2 associations.Entity
	Param_param3 associations.AssocKind
	Param_param4 associations.EntityKind
	Param_param5 map[string]interface{}
	Param_param6 associations.AssocKind
}

func (self *consumer_HealthReporterWriter) ReplayBulkUpdateAssocCall(context context.Context, jsonData []byte) (newResults []interface{}, err error) {

	//Initialize old & new results, and the value to deserialize to
	newResults = []interface{}{}
	deserializedMessage := HealthReporterWriterBulkUpdateAssocMessage{}

	//Deserialize kinesis record to struct
	err = json.Unmarshal(jsonData, &deserializedMessage)
	if err != nil {
		log.Fatalln(err)
		return
	}

	//Replay
	retVal1 := self.inner.BulkUpdateAssoc(context,
		deserializedMessage.Param_param2,
		deserializedMessage.Param_param3,
		deserializedMessage.Param_param4,
		deserializedMessage.Param_param5,
		deserializedMessage.Param_param6,
	)

	//Bail if the replay had a serious error
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		err = retVal1
		return
	}

	//If the replay worked out, record the results
	newResults = []interface{}{retVal1}
	return
}

//HealthReporterWriterCreateAssocMessage represents a deserialized kinesis replay record
//for the CreateAssoc method
type HealthReporterWriterCreateAssocMessage struct {
	Param_param2 associations.Entity
	Param_param3 associations.AssocKind
	Param_param4 associations.Entity
	Param_param5 map[string]interface{}
	Param_param6 time.Time
}

func (self *consumer_HealthReporterWriter) ReplayCreateAssocCall(context context.Context, jsonData []byte) (newResults []interface{}, err error) {

	//Initialize old & new results, and the value to deserialize to
	newResults = []interface{}{}
	deserializedMessage := HealthReporterWriterCreateAssocMessage{}

	//Deserialize kinesis record to struct
	err = json.Unmarshal(jsonData, &deserializedMessage)
	if err != nil {
		log.Fatalln(err)
		return
	}

	//Replay
	retVal1 := self.inner.CreateAssoc(context,
		deserializedMessage.Param_param2,
		deserializedMessage.Param_param3,
		deserializedMessage.Param_param4,
		deserializedMessage.Param_param5,
		deserializedMessage.Param_param6,
	)

	//Bail if the replay had a serious error
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		err = retVal1
		return
	}

	//If the replay worked out, record the results
	newResults = []interface{}{retVal1}
	return
}

//HealthReporterWriterDeleteAssocMessage represents a deserialized kinesis replay record
//for the DeleteAssoc method
type HealthReporterWriterDeleteAssocMessage struct {
	Param_param2 associations.Entity
	Param_param3 associations.AssocKind
	Param_param4 associations.Entity
}

func (self *consumer_HealthReporterWriter) ReplayDeleteAssocCall(context context.Context, jsonData []byte) (newResults []interface{}, err error) {

	//Initialize old & new results, and the value to deserialize to
	newResults = []interface{}{}
	deserializedMessage := HealthReporterWriterDeleteAssocMessage{}

	//Deserialize kinesis record to struct
	err = json.Unmarshal(jsonData, &deserializedMessage)
	if err != nil {
		log.Fatalln(err)
		return
	}

	//Replay
	retVal1 := self.inner.DeleteAssoc(context,
		deserializedMessage.Param_param2,
		deserializedMessage.Param_param3,
		deserializedMessage.Param_param4,
	)

	//Bail if the replay had a serious error
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		err = retVal1
		return
	}

	//If the replay worked out, record the results
	newResults = []interface{}{retVal1}
	return
}

//HealthReporterWriterUpdateAssocMessage represents a deserialized kinesis replay record
//for the UpdateAssoc method
type HealthReporterWriterUpdateAssocMessage struct {
	Param_param2 associations.Entity
	Param_param3 associations.AssocKind
	Param_param4 associations.Entity
	Param_param5 map[string]interface{}
	Param_param6 associations.AssocKind
}

func (self *consumer_HealthReporterWriter) ReplayUpdateAssocCall(context context.Context, jsonData []byte) (newResults []interface{}, err error) {

	//Initialize old & new results, and the value to deserialize to
	newResults = []interface{}{}
	deserializedMessage := HealthReporterWriterUpdateAssocMessage{}

	//Deserialize kinesis record to struct
	err = json.Unmarshal(jsonData, &deserializedMessage)
	if err != nil {
		log.Fatalln(err)
		return
	}

	//Replay
	retVal1 := self.inner.UpdateAssoc(context,
		deserializedMessage.Param_param2,
		deserializedMessage.Param_param3,
		deserializedMessage.Param_param4,
		deserializedMessage.Param_param5,
		deserializedMessage.Param_param6,
	)

	//Bail if the replay had a serious error
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		err = retVal1
		return
	}

	//If the replay worked out, record the results
	newResults = []interface{}{retVal1}
	return
}
