// Generated by: main
// TypeWriter: migrationproducer
// Directive: +gen on HealthReporterWriter

package datastore

import (
	"time"

	"code.justin.tv/d8a/migration"
	"code.justin.tv/web/cohesion/associations"
	"golang.org/x/net/context"
)

//CreateHealthReporterWriterProducer is a method that builds a decorator for a HealthReporterWriter object which writes backend method calls to
//kinesis.
func CreateHealthReporterWriterProducer(inner HealthReporterWriter, statsdHostPort string, environment string, repo string,
	partitionKeyBuilder migration.PartitionKeyBuilder, awsProfile string, region string,
	streamName string, errCheck migration.ErrorCheck) HealthReporterWriter {

	return &producer_HealthReporterWriter{
		inner: inner,
		eventWriter: migration.CreateKinesisWriter(statsdHostPort, environment, repo, "HealthReporterWriter",
			partitionKeyBuilder, awsProfile, region, streamName),
		errCheck: errCheck,
	}
}

type producer_HealthReporterWriter struct {
	inner       HealthReporterWriter
	eventWriter migration.EventWriter
	errCheck    migration.ErrorCheck
}

//BatchUpdateAssoc is a producer method that calls the decorated backend, then writes the results & timings to
//kinesis.
func (self *producer_HealthReporterWriter) BatchUpdateAssoc(param1 context.Context,
	param2 []associations.Association,
) (int64, error) {

	begin := time.Now()

	//Call method on inner backend
	retVal1, retVal2 := self.inner.BatchUpdateAssoc(param1,
		param2,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		return retVal1, retVal2
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	go func(ctx context.Context) {
		//Write to kinesis - write the method name, duration of the call, parameters used, and return value(s)
		self.eventWriter.Write("BatchUpdateAssoc",
			map[string]interface{}{
				"param2": param2,
			}, //Parameter map
			[]interface{}{retVal1, retVal2}, //Return value array
			duration)
	}(newCtx)

	return retVal1, retVal2
}

//BulkDeleteAssoc is a producer method that calls the decorated backend, then writes the results & timings to
//kinesis.
func (self *producer_HealthReporterWriter) BulkDeleteAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.EntityKind,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.BulkDeleteAssoc(param1,
		param2,
		param3,
		param4,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	go func(ctx context.Context) {
		//Write to kinesis - write the method name, duration of the call, parameters used, and return value(s)
		self.eventWriter.Write("BulkDeleteAssoc",
			map[string]interface{}{
				"param2": param2,
				"param3": param3,
				"param4": param4,
			}, //Parameter map
			[]interface{}{retVal1}, //Return value array
			duration)
	}(newCtx)

	return retVal1
}

//BulkUpdateAssoc is a producer method that calls the decorated backend, then writes the results & timings to
//kinesis.
func (self *producer_HealthReporterWriter) BulkUpdateAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.EntityKind,
	param5 map[string]interface{},
	param6 associations.AssocKind,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.BulkUpdateAssoc(param1,
		param2,
		param3,
		param4,
		param5,
		param6,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	go func(ctx context.Context) {
		//Write to kinesis - write the method name, duration of the call, parameters used, and return value(s)
		self.eventWriter.Write("BulkUpdateAssoc",
			map[string]interface{}{
				"param2": param2,
				"param3": param3,
				"param4": param4,
				"param5": param5,
				"param6": param6,
			}, //Parameter map
			[]interface{}{retVal1}, //Return value array
			duration)
	}(newCtx)

	return retVal1
}

//CreateAssoc is a producer method that calls the decorated backend, then writes the results & timings to
//kinesis.
func (self *producer_HealthReporterWriter) CreateAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.Entity,
	param5 map[string]interface{},
	param6 time.Time,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.CreateAssoc(param1,
		param2,
		param3,
		param4,
		param5,
		param6,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	go func(ctx context.Context) {
		//Write to kinesis - write the method name, duration of the call, parameters used, and return value(s)
		self.eventWriter.Write("CreateAssoc",
			map[string]interface{}{
				"param2": param2,
				"param3": param3,
				"param4": param4,
				"param5": param5,
				"param6": param6,
			}, //Parameter map
			[]interface{}{retVal1}, //Return value array
			duration)
	}(newCtx)

	return retVal1
}

//DeleteAssoc is a producer method that calls the decorated backend, then writes the results & timings to
//kinesis.
func (self *producer_HealthReporterWriter) DeleteAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.Entity,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.DeleteAssoc(param1,
		param2,
		param3,
		param4,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	go func(ctx context.Context) {
		//Write to kinesis - write the method name, duration of the call, parameters used, and return value(s)
		self.eventWriter.Write("DeleteAssoc",
			map[string]interface{}{
				"param2": param2,
				"param3": param3,
				"param4": param4,
			}, //Parameter map
			[]interface{}{retVal1}, //Return value array
			duration)
	}(newCtx)

	return retVal1
}

//Health is a decorator method that passes directly through to the decorated backend
func (self *producer_HealthReporterWriter) Health(param1 context.Context,
) error {

	//Call method on inner backend
	retVal1 := self.inner.Health(param1)

	return retVal1
}

//Name is a decorator method that passes directly through to the decorated backend
func (self *producer_HealthReporterWriter) Name() string {

	//Call method on inner backend
	retVal1 := self.inner.Name()

	return retVal1
}

//SetName is a decorator method that passes directly through to the decorated backend
func (self *producer_HealthReporterWriter) SetName(param1 string,
) {

	//Call method on inner backend
	self.inner.SetName(param1)

	return
}

//UpdateAssoc is a producer method that calls the decorated backend, then writes the results & timings to
//kinesis.
func (self *producer_HealthReporterWriter) UpdateAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.Entity,
	param5 map[string]interface{},
	param6 associations.AssocKind,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.UpdateAssoc(param1,
		param2,
		param3,
		param4,
		param5,
		param6,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 500*time.Millisecond)

	go func(ctx context.Context) {
		//Write to kinesis - write the method name, duration of the call, parameters used, and return value(s)
		self.eventWriter.Write("UpdateAssoc",
			map[string]interface{}{
				"param2": param2,
				"param3": param3,
				"param4": param4,
				"param5": param5,
				"param6": param6,
			}, //Parameter map
			[]interface{}{retVal1}, //Return value array
			duration)
	}(newCtx)

	return retVal1
}

//Utilization is a decorator method that passes directly through to the decorated backend
func (self *producer_HealthReporterWriter) Utilization(param1 context.Context,
) float32 {

	//Call method on inner backend
	retVal1 := self.inner.Utilization(param1)

	return retVal1
}
