// Generated by: main
// TypeWriter: migrationsecondary
// Directive: +gen on HealthReporterWriter

package datastore

import (
	"time"

	"code.justin.tv/d8a/migration"
	"code.justin.tv/d8a/migration/comparison"
	"code.justin.tv/web/cohesion/associations"
	"golang.org/x/net/context"
)

//CreateHealthReporterWriterSecondary is a method that builds a decorator for a HealthReporterWriter object which mirrors calls
//to a map of secondary HealthReporterWriter objects and compares results and timings.
func CreateHealthReporterWriterSecondary(inner HealthReporterWriter, statsdHostPort string, logLevel comparison.LogLevel, preprocessor comparison.ComparePreprocessor, environment string, repo string,
	errCheck migration.ErrorCheck, secondaries map[string]Writer) HealthReporterWriter {

	return &secondary_HealthReporterWriter{
		inner:        inner,
		callComparer: migration.CreateCallComparer(statsdHostPort, logLevel, preprocessor, environment, repo, "HealthReporterWriter"),
		secondaries:  secondaries,
		errCheck:     errCheck,
	}
}

type secondary_HealthReporterWriter struct {
	inner        HealthReporterWriter
	callComparer migration.CallComparer
	secondaries  map[string]Writer
	errCheck     migration.ErrorCheck
}

//BatchUpdateAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterWriter) BatchUpdateAssoc(param1 context.Context,
	param2 []associations.Association,
) (int64, error) {

	begin := time.Now()

	//Call method on inner backend
	retVal1, retVal2 := self.inner.BatchUpdateAssoc(param1,
		param2,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal2 != nil && self.errCheck.SeriousError(retVal2) {
		return retVal1, retVal2
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 2*time.Second)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("BatchUpdateAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Writer) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("BatchUpdateAssoc", secName, duration,
				[]interface{}{param2}, []interface{}{retVal1, retVal2}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1, secondaryRetVal2 := sec.BatchUpdateAssoc(ctx,
						param2,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal2 != nil && self.errCheck.SeriousError(secondaryRetVal2) {
						return []interface{}{}, secondaryRetVal2
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1, secondaryRetVal2}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1, retVal2
}

//BulkDeleteAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterWriter) BulkDeleteAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.EntityKind,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.BulkDeleteAssoc(param1,
		param2,
		param3,
		param4,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 2*time.Second)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("BulkDeleteAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Writer) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("BulkDeleteAssoc", secName, duration,
				[]interface{}{param2, param3, param4}, []interface{}{retVal1}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1 := sec.BulkDeleteAssoc(ctx,
						param2,
						param3,
						param4,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal1 != nil && self.errCheck.SeriousError(secondaryRetVal1) {
						return []interface{}{}, secondaryRetVal1
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1
}

//BulkUpdateAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterWriter) BulkUpdateAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.EntityKind,
	param5 map[string]interface{},
	param6 associations.AssocKind,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.BulkUpdateAssoc(param1,
		param2,
		param3,
		param4,
		param5,
		param6,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 2*time.Second)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("BulkUpdateAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Writer) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("BulkUpdateAssoc", secName, duration,
				[]interface{}{param2, param3, param4, param5, param6}, []interface{}{retVal1}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1 := sec.BulkUpdateAssoc(ctx,
						param2,
						param3,
						param4,
						param5,
						param6,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal1 != nil && self.errCheck.SeriousError(secondaryRetVal1) {
						return []interface{}{}, secondaryRetVal1
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1
}

//CreateAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterWriter) CreateAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.Entity,
	param5 map[string]interface{},
	param6 time.Time,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.CreateAssoc(param1,
		param2,
		param3,
		param4,
		param5,
		param6,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 2*time.Second)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("CreateAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Writer) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("CreateAssoc", secName, duration,
				[]interface{}{param2, param3, param4, param5, param6}, []interface{}{retVal1}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1 := sec.CreateAssoc(ctx,
						param2,
						param3,
						param4,
						param5,
						param6,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal1 != nil && self.errCheck.SeriousError(secondaryRetVal1) {
						return []interface{}{}, secondaryRetVal1
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1
}

//DeleteAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterWriter) DeleteAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.Entity,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.DeleteAssoc(param1,
		param2,
		param3,
		param4,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 2*time.Second)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("DeleteAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Writer) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("DeleteAssoc", secName, duration,
				[]interface{}{param2, param3, param4}, []interface{}{retVal1}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1 := sec.DeleteAssoc(ctx,
						param2,
						param3,
						param4,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal1 != nil && self.errCheck.SeriousError(secondaryRetVal1) {
						return []interface{}{}, secondaryRetVal1
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1
}

//Health is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterWriter) Health(param1 context.Context,
) error {

	//Call method on inner backend
	retVal1 := self.inner.Health(param1)

	return retVal1
}

//Name is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterWriter) Name() string {

	//Call method on inner backend
	retVal1 := self.inner.Name()

	return retVal1
}

//SetName is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterWriter) SetName(param1 string,
) {

	//Call method on inner backend
	self.inner.SetName(param1)

	return
}

//UpdateAssoc is a secondary mirroring method that calls the decorated backend, then the listed secondary backends
//and compares their results and timings.
func (self *secondary_HealthReporterWriter) UpdateAssoc(param1 context.Context,
	param2 associations.Entity,
	param3 associations.AssocKind,
	param4 associations.Entity,
	param5 map[string]interface{},
	param6 associations.AssocKind,
) error {

	begin := time.Now()

	//Call method on inner backend
	retVal1 := self.inner.UpdateAssoc(param1,
		param2,
		param3,
		param4,
		param5,
		param6,
	)

	//Escape if the inner backend returned an error- don't write to kinesis
	if retVal1 != nil && self.errCheck.SeriousError(retVal1) {
		return retVal1
	}

	duration := time.Now().Sub(begin)

	//When this method returns, the response will be sent & the root context will be cancelled-
	//to make sure that these goroutines have a chance of completing, we need a fresh context to execute
	//them on.
	newCtx, _ := context.WithTimeout(context.Background(), 2*time.Second)

	//Write the timing to graphite so we can compare to secondary call duration
	self.callComparer.RecordPrimary("UpdateAssoc", duration)

	//Mirror to each secondary & compare
	for key, secondary := range self.secondaries {
		go func(ctx context.Context, secName string, sec Writer) {
			//callComparer.SecondaryCall takes care of wrapping the passed func with timings and
			//comparing results with the primary
			self.callComparer.SecondaryCall("UpdateAssoc", secName, duration,
				[]interface{}{param2, param3, param4, param5, param6}, []interface{}{retVal1}, func() ([]interface{}, error) {

					//Call secondary
					secondaryRetVal1 := sec.UpdateAssoc(ctx,
						param2,
						param3,
						param4,
						param5,
						param6,
					)

					//Bail if the secondary backend had a serious error
					if secondaryRetVal1 != nil && self.errCheck.SeriousError(secondaryRetVal1) {
						return []interface{}{}, secondaryRetVal1
					}

					//Return secondary results
					return []interface{}{secondaryRetVal1}, nil
				})
		}(newCtx, key, secondary)
	}

	return retVal1
}

//Utilization is a decorator method that passes directly through to the decorated backend
func (self *secondary_HealthReporterWriter) Utilization(param1 context.Context,
) float32 {

	//Call method on inner backend
	retVal1 := self.inner.Utilization(param1)

	return retVal1
}
