
GIT_COMMIT ?= $(shell git rev-parse --verify HEAD)
ENVIRONMENT ?= development
LOCAL_PACKAGES ?= $(shell glide novendor)
GOIMPORTS_REV ?= 5e2ae75
GOCOVMERGE_REV ?= b5bfa59
GOMETALINTER_REV ?= 5ad7a56e
GOTEST ?= .
GOMETALINTER_ARGS ?= --vendor --dupl-threshold=150 --min-confidence=.3 --tests --deadline=90s --disable-all \
	-Egolint -Etest -Eineffassign -Etestify -Eunconvert -Estaticcheck -Egoconst -Egocyclo -Eerrcheck \
	-Egofmt -Evet -Edupl -Einterfacer -Estructcheck -Evetshadow -Egosimple -Egoimports -Evarcheck -Emisspell \
	-Ealigncheck -Etest --exclude=/usr/local/go/src --exclude='/mocks/[^/]+\.go.*\((dupl)|(golint)\)' ./...

go_get_rev = go get -d $(1)/... && cd "$(GOPATH)/src/$(1)" && git reset --hard $(2) && go install ./...

precommit: fix fast_lint test build

setup:
	$(call go_get_rev,golang.org/x/tools/cmd/goimports,$(GOIMPORTS_REV))
	$(call go_get_rev,github.com/wadey/gocovmerge,$(GOCOVMERGE_REV))
	$(call go_get_rev,github.com/alecthomas/gometalinter,$(GOMETALINTER_REV))
	go get -u github.com/jstemmer/go-junit-report
	gometalinter --install
	# Print some debug stuff so we can know why the build is failing
	echo $(PATH)
	which go
	which gcc
	go version
	which gometalinter


lint:
	gometalinter $(GOMETALINTER_ARGS)

fast_lint:
	gometalinter --fast $(GOMETALINTER_ARGS)

test:
	go test -v -race $(LOCAL_PACKAGES) | go-junit-report > test_report.xml

integration_test:
	env ENVIRONMENT=$(ENVIRONMENT) go test -race -run=$(GOTEST) -tags=integration $(LOCAL_PACKAGES)

build:
	go build -ldflags "-X main.CodeVersion=$(GIT_COMMIT)" $(MAIN_DIR)

run:
	env ENVIRONMENT=$(ENVIRONMENT) go run -race -ldflags "-X main.CodeVersion=$(GIT_COMMIT)" $(MAIN_DIR)/main.go

fix:
	find . -iname '*.go' -not -path '*/vendor/*' -print0 | xargs -0 gofmt -s -w
	find . -iname '*.go' -not -path '*/vendor/*' -print0 | xargs -0 goimports -w
	terraform fmt

# WARNING: WILL `git clean` YOUR REPOSITORY, removing all ignored and not checked in files.
# This simulates a 'fresh' install.
# Will find all terraform files for our systems and verify that, from clean, they plan nothing.  Use this after pushing to master to verify your terraform
# is applied.
terraform_check:
	git clean -dx -f -f
	find . -name main.tf -exec dirname {} \; | grep -v '/.terraform' | grep -v modules | xargs -I {} bash -c 'cd {} && echo {} && terraform init && terraform plan -detailed-exitcode && cd -'

integration_test_cover:
	rm -f cover.out uncovered_functions.txt uncovered_functions.txt function_coverage.txt
	go list -f "env ENVIRONMENT=$(ENVIRONMENT) go test -race -timeout 3m -tags=integration -coverprofile {{.Name}}_{{len .Imports}}_{{len .Deps}}.coverprofile -coverpkg ./cmd/... {{.ImportPath}}" ./cmd/... | xargs -I {} bash -c {}
	gocovmerge `ls *.coverprofile` > cover.out
	rm *.coverprofile
	go tool cover -func cover.out > function_coverage.txt
	# pipe to cat to swallow the error code
	grep '\s0.0%' function_coverage.txt | cat > uncovered_functions.txt
	cat function_coverage.txt
	rm cover.out
	if [ -s uncovered_functions.txt ]; then (echo "There are uncovered functions" && cat uncovered_functions.txt && exit 1) fi;
	rm -f cover.out uncovered_functions.txt uncovered_functions.txt function_coverage.txt
