package hystrix

import (
	"testing"
	"time"

	. "github.com/smartystreets/goconvey/convey"
)

func TestConfigureConcurrency(t *testing.T) {
	Convey("given a command configured for 100 concurrent requests", t, func() {
		circuits := NewCircuits()
		circuits.ConfigureCommand("", CommandConfig{MaxConcurrentRequests: 100})

		Convey("reading the concurrency should be the same", func() {
			So(circuits.getSettings("").MaxConcurrentRequests, ShouldEqual, 100)
		})
	})
}

func TestConfigureTimeout(t *testing.T) {
	Convey("given a command configured for a 10000 milliseconds", t, func() {
		circuits := NewCircuits()
		circuits.ConfigureCommand("", CommandConfig{Timeout: 10000})

		Convey("reading the timeout should be the same", func() {
			So(circuits.getSettings("").Timeout, ShouldEqual, time.Duration(10*time.Second))
		})
	})
}

func TestConfigureRVT(t *testing.T) {
	Convey("given a command configured to need 30 requests before tripping the circuit", t, func() {
		circuits := NewCircuits()
		circuits.ConfigureCommand("", CommandConfig{RequestVolumeThreshold: 30})

		Convey("reading the threshold should be the same", func() {
			So(circuits.getSettings("").RequestVolumeThreshold, ShouldEqual, uint64(30))
		})
	})
}

func TestSleepWindowDefault(t *testing.T) {
	Convey("given default settings", t, func() {
		circuits := NewCircuits()
		circuits.ConfigureCommand("", CommandConfig{})

		Convey("the sleep window should be 5 seconds", func() {
			So(circuits.getSettings("").SleepWindow, ShouldEqual, time.Duration(5*time.Second))
		})
	})
}

func TestGetCircuitSettings(t *testing.T) {
	Convey("when calling GetCircuitSettings", t, func() {
		circuits := NewCircuits()
		circuits.ConfigureCommand("test", CommandConfig{Timeout: 30000})

		Convey("should read the same setting just added", func() {
			So(circuits.getCircuitSettings()["test"], ShouldEqual, circuits.getSettings("test"))
			So(circuits.getCircuitSettings()["test"].Timeout, ShouldEqual, time.Duration(30*time.Second))
		})
	})
}
