package httpapi

import (
	"net/http"

	"code.justin.tv/feeds/jackup3/proto/jackup3"
	"code.justin.tv/hygienic/basehttpserver"
	"code.justin.tv/sse/malachai/pkg/s2s/callee"
)

// HTTPServer exposes our twirp service
type HTTPServer struct {
	basehttpserver.HTTPServer
	Jackup3Server jackup3.TwirpServer
	S2SClient     *callee.Client
}

// Setup registers all the HTTPHandlers on the server's mux
func (h *HTTPServer) Setup() error {
	handler := http.Handler(h.Jackup3Server)
	if h.S2SClient != nil {
		handler = h.S2SClient.RequestValidatorMiddleware(h.Jackup3Server)
	}
	h.Mux.Handle(jackup3.Jackup3PathPrefix, handler)
	return h.HTTPServer.Setup()
}
