package twirpjackup3

import (
	"context"
	"testing"

	"code.justin.tv/feeds/jackup3/proto/jackup3"
)

func TestJackup3Impl_ItemGet(t *testing.T) {
	e := Jackup3Impl{
		SecretKey: "hi",
	}
	resp, err := e.ItemGet(context.Background(), &jackup3.ItemGetRequest{
		Key: "hi",
	})
	if err != nil {
		t.Error("expected no error")
	}
	if resp.Value != "YOU GUESSED THE SECRET KEY" {
		t.Error("You should be able to guess the secret key")
	}
}

func TestJackup3Impl_ItemError(t *testing.T) {
	e := Jackup3Impl{
		SecretKey: "hi",
	}
	_, err := e.ItemGet(context.Background(), &jackup3.ItemGetRequest{
		Key: "-downstream_failure-",
	})
	if err == nil {
		t.Error("expected an error")
	}
}
