#!/bin/bash
# For help, run ./make.sh
set -euo pipefail
. vars.sh
. ./scripts/jenkins_cf_deployer/all.sh

# Populate environment variables you app needs to execute. This is only used
# when running your code locally.
function populate_app_env() {
  INFRA=${INFRA-staging}
  export jackup3secret=abc
  export ENVIRONMENT=development
  export ITEM_GET_TABLE=${ITEM_GET_TABLE-$(cached_cloudformation_output ${SERVICE}:${INFRA}:ItemGetTable)}
  [ ! -z ${ITEM_GET_TABLE} ]
  # If you listen on SSL, you'll need to use https here instead.
  export jackup3_host=${jackup3_host-"http://$(        cached_cloudformation_output ${SERVICE}:${INFRA}:LBDNS)"}
  [ ! -z ${jackup3_host} ]
  export SANDSTORM_ARN_FIXME="_EMPTY_"
  # TODO: Add note about where this exists and why
#  export SANDSTORM_ARN=${SANDSTORM_ARN-$(  cached_cloudformation_output ${SERVICE}:${INFRA}:SandstormARN)}
#  [ ! -z ${SANDSTORM_ARN} ]
}

# Uncomment this when you're done setting up to remove bootstrapping from your build processing
#unset -f root__bootstrap
process_build root__ $@
