#!/bin/bash

function root__docker() {
  # TODO: Replace [ ] with [[ ]]  See http://mywiki.wooledge.org/BashFAQ/031 and https://serverfault.com/questions/52034/what-is-the-difference-between-double-and-single-square-brackets-in-bash
  if [ "${1-}" == "help" ]; then
    echo "Runs docker related commands"
    exit 0
  fi
  process_build docker__ $@
}

function docker__clean() {
  if [ "${1-}" == "help" ]; then
    echo "Clear out the docker cache (if you run out of disk space)"
    exit 0
  fi
  docker system prune -a
}

function docker__lint() {
  if [ "${1-}" == "help" ]; then
    echo "Lint a dockerfile"
    exit 0
  fi
  if [ "${USE_BUILDER}" == "true" ]; then
    make_exec builder run docker lint $@
  fi
  hadolint $@
}

function docker__build_integration() {
  if [ "${1-}" == "help" ]; then
    echo "Create integration test docker image"
    exit 0
  fi
  SUFFIX=""
  if is_git_dirty; then
    echo "Warning.  Your git status is dirty.  Building an image tagged as dirty."
    echo "You may have trouble pushing your dirty image.  I suggest cleaning up git status and trying again"
    SUFFIX="-dirty"
  fi
	docker build --build-arg REPO=${REPO} --build-arg BUILDER=${BUILDER} -f cmd/${SERVICE}/Dockerfile_integration_test -t ${SERVICE}:integration-${GIT_COMMIT}${SUFFIX} .
}

function docker__build() {
  if [ "${1-}" == "help" ]; then
    echo "Create the service's docker image"
    exit 0
  fi
  SUFFIX=""
  if is_git_dirty; then
    echo "Warning.  Your git status is dirty.  Building an image tagged as dirty."
    echo "You may have trouble pushing your dirty image.  I suggest cleaning up git status and trying again"
    SUFFIX="-dirty"
  fi
  docker build --build-arg REPO=${REPO} --build-arg BUILDER=${BUILDER} -f cmd/${SERVICE}/Dockerfile -t ${SERVICE}:app-${GIT_COMMIT}${SUFFIX} .
}