// Code generated by aws/endpoints/v3model_codegen.go. DO NOT EDIT.

package endpoints

import (
	"regexp"
)

// Partition identifiers
const (
	AwsPartitionID      = "aws"        // AWS Standard partition.
	AwsCnPartitionID    = "aws-cn"     // AWS China partition.
	AwsUsGovPartitionID = "aws-us-gov" // AWS GovCloud (US) partition.
)

// AWS Standard partition's regions.
const (
	ApNortheast1RegionID = "ap-northeast-1" // Asia Pacific (Tokyo).
	ApNortheast2RegionID = "ap-northeast-2" // Asia Pacific (Seoul).
	ApSouth1RegionID     = "ap-south-1"     // Asia Pacific (Mumbai).
	ApSoutheast1RegionID = "ap-southeast-1" // Asia Pacific (Singapore).
	ApSoutheast2RegionID = "ap-southeast-2" // Asia Pacific (Sydney).
	CaCentral1RegionID   = "ca-central-1"   // Canada (Central).
	EuCentral1RegionID   = "eu-central-1"   // EU (Frankfurt).
	EuWest1RegionID      = "eu-west-1"      // EU (Ireland).
	EuWest2RegionID      = "eu-west-2"      // EU (London).
	EuWest3RegionID      = "eu-west-3"      // EU (Paris).
	SaEast1RegionID      = "sa-east-1"      // South America (Sao Paulo).
	UsEast1RegionID      = "us-east-1"      // US East (N. Virginia).
	UsEast2RegionID      = "us-east-2"      // US East (Ohio).
	UsWest1RegionID      = "us-west-1"      // US West (N. California).
	UsWest2RegionID      = "us-west-2"      // US West (Oregon).
)

// AWS China partition's regions.
const (
	CnNorth1RegionID     = "cn-north-1"     // China (Beijing).
	CnNorthwest1RegionID = "cn-northwest-1" // China (Ningxia).
)

// AWS GovCloud (US) partition's regions.
const (
	UsGovWest1RegionID = "us-gov-west-1" // AWS GovCloud (US).
)

// Service identifiers
const (
	A4bServiceID                          = "a4b"                          // A4b.
	AcmServiceID                          = "acm"                          // Acm.
	AcmPcaServiceID                       = "acm-pca"                      // AcmPca.
	ApiMediatailorServiceID               = "api.mediatailor"              // ApiMediatailor.
	ApiPricingServiceID                   = "api.pricing"                  // ApiPricing.
	ApiSagemakerServiceID                 = "api.sagemaker"                // ApiSagemaker.
	ApigatewayServiceID                   = "apigateway"                   // Apigateway.
	ApplicationAutoscalingServiceID       = "application-autoscaling"      // ApplicationAutoscaling.
	Appstream2ServiceID                   = "appstream2"                   // Appstream2.
	AppsyncServiceID                      = "appsync"                      // Appsync.
	AthenaServiceID                       = "athena"                       // Athena.
	AutoscalingServiceID                  = "autoscaling"                  // Autoscaling.
	AutoscalingPlansServiceID             = "autoscaling-plans"            // AutoscalingPlans.
	BatchServiceID                        = "batch"                        // Batch.
	BudgetsServiceID                      = "budgets"                      // Budgets.
	CeServiceID                           = "ce"                           // Ce.
	ChimeServiceID                        = "chime"                        // Chime.
	Cloud9ServiceID                       = "cloud9"                       // Cloud9.
	ClouddirectoryServiceID               = "clouddirectory"               // Clouddirectory.
	CloudformationServiceID               = "cloudformation"               // Cloudformation.
	CloudfrontServiceID                   = "cloudfront"                   // Cloudfront.
	CloudhsmServiceID                     = "cloudhsm"                     // Cloudhsm.
	Cloudhsmv2ServiceID                   = "cloudhsmv2"                   // Cloudhsmv2.
	CloudsearchServiceID                  = "cloudsearch"                  // Cloudsearch.
	CloudtrailServiceID                   = "cloudtrail"                   // Cloudtrail.
	CodebuildServiceID                    = "codebuild"                    // Codebuild.
	CodecommitServiceID                   = "codecommit"                   // Codecommit.
	CodedeployServiceID                   = "codedeploy"                   // Codedeploy.
	CodepipelineServiceID                 = "codepipeline"                 // Codepipeline.
	CodestarServiceID                     = "codestar"                     // Codestar.
	CognitoIdentityServiceID              = "cognito-identity"             // CognitoIdentity.
	CognitoIdpServiceID                   = "cognito-idp"                  // CognitoIdp.
	CognitoSyncServiceID                  = "cognito-sync"                 // CognitoSync.
	ComprehendServiceID                   = "comprehend"                   // Comprehend.
	ConfigServiceID                       = "config"                       // Config.
	CurServiceID                          = "cur"                          // Cur.
	DatapipelineServiceID                 = "datapipeline"                 // Datapipeline.
	DaxServiceID                          = "dax"                          // Dax.
	DevicefarmServiceID                   = "devicefarm"                   // Devicefarm.
	DirectconnectServiceID                = "directconnect"                // Directconnect.
	DiscoveryServiceID                    = "discovery"                    // Discovery.
	DmsServiceID                          = "dms"                          // Dms.
	DsServiceID                           = "ds"                           // Ds.
	DynamodbServiceID                     = "dynamodb"                     // Dynamodb.
	Ec2ServiceID                          = "ec2"                          // Ec2.
	Ec2metadataServiceID                  = "ec2metadata"                  // Ec2metadata.
	EcrServiceID                          = "ecr"                          // Ecr.
	EcsServiceID                          = "ecs"                          // Ecs.
	ElasticacheServiceID                  = "elasticache"                  // Elasticache.
	ElasticbeanstalkServiceID             = "elasticbeanstalk"             // Elasticbeanstalk.
	ElasticfilesystemServiceID            = "elasticfilesystem"            // Elasticfilesystem.
	ElasticloadbalancingServiceID         = "elasticloadbalancing"         // Elasticloadbalancing.
	ElasticmapreduceServiceID             = "elasticmapreduce"             // Elasticmapreduce.
	ElastictranscoderServiceID            = "elastictranscoder"            // Elastictranscoder.
	EmailServiceID                        = "email"                        // Email.
	EntitlementMarketplaceServiceID       = "entitlement.marketplace"      // EntitlementMarketplace.
	EsServiceID                           = "es"                           // Es.
	EventsServiceID                       = "events"                       // Events.
	FirehoseServiceID                     = "firehose"                     // Firehose.
	FmsServiceID                          = "fms"                          // Fms.
	GameliftServiceID                     = "gamelift"                     // Gamelift.
	GlacierServiceID                      = "glacier"                      // Glacier.
	GlueServiceID                         = "glue"                         // Glue.
	GreengrassServiceID                   = "greengrass"                   // Greengrass.
	GuarddutyServiceID                    = "guardduty"                    // Guardduty.
	HealthServiceID                       = "health"                       // Health.
	IamServiceID                          = "iam"                          // Iam.
	ImportexportServiceID                 = "importexport"                 // Importexport.
	InspectorServiceID                    = "inspector"                    // Inspector.
	IotServiceID                          = "iot"                          // Iot.
	IotanalyticsServiceID                 = "iotanalytics"                 // Iotanalytics.
	KinesisServiceID                      = "kinesis"                      // Kinesis.
	KinesisanalyticsServiceID             = "kinesisanalytics"             // Kinesisanalytics.
	KinesisvideoServiceID                 = "kinesisvideo"                 // Kinesisvideo.
	KmsServiceID                          = "kms"                          // Kms.
	LambdaServiceID                       = "lambda"                       // Lambda.
	LightsailServiceID                    = "lightsail"                    // Lightsail.
	LogsServiceID                         = "logs"                         // Logs.
	MachinelearningServiceID              = "machinelearning"              // Machinelearning.
	MarketplacecommerceanalyticsServiceID = "marketplacecommerceanalytics" // Marketplacecommerceanalytics.
	MediaconvertServiceID                 = "mediaconvert"                 // Mediaconvert.
	MedialiveServiceID                    = "medialive"                    // Medialive.
	MediapackageServiceID                 = "mediapackage"                 // Mediapackage.
	MediastoreServiceID                   = "mediastore"                   // Mediastore.
	MeteringMarketplaceServiceID          = "metering.marketplace"         // MeteringMarketplace.
	MghServiceID                          = "mgh"                          // Mgh.
	MobileanalyticsServiceID              = "mobileanalytics"              // Mobileanalytics.
	ModelsLexServiceID                    = "models.lex"                   // ModelsLex.
	MonitoringServiceID                   = "monitoring"                   // Monitoring.
	MturkRequesterServiceID               = "mturk-requester"              // MturkRequester.
	NeptuneServiceID                      = "neptune"                      // Neptune.
	OpsworksServiceID                     = "opsworks"                     // Opsworks.
	OpsworksCmServiceID                   = "opsworks-cm"                  // OpsworksCm.
	OrganizationsServiceID                = "organizations"                // Organizations.
	PinpointServiceID                     = "pinpoint"                     // Pinpoint.
	PollyServiceID                        = "polly"                        // Polly.
	RdsServiceID                          = "rds"                          // Rds.
	RedshiftServiceID                     = "redshift"                     // Redshift.
	RekognitionServiceID                  = "rekognition"                  // Rekognition.
	ResourceGroupsServiceID               = "resource-groups"              // ResourceGroups.
	Route53ServiceID                      = "route53"                      // Route53.
	Route53domainsServiceID               = "route53domains"               // Route53domains.
	RuntimeLexServiceID                   = "runtime.lex"                  // RuntimeLex.
	RuntimeSagemakerServiceID             = "runtime.sagemaker"            // RuntimeSagemaker.
	S3ServiceID                           = "s3"                           // S3.
	SdbServiceID                          = "sdb"                          // Sdb.
	SecretsmanagerServiceID               = "secretsmanager"               // Secretsmanager.
	ServerlessrepoServiceID               = "serverlessrepo"               // Serverlessrepo.
	ServicecatalogServiceID               = "servicecatalog"               // Servicecatalog.
	ServicediscoveryServiceID             = "servicediscovery"             // Servicediscovery.
	ShieldServiceID                       = "shield"                       // Shield.
	SmsServiceID                          = "sms"                          // Sms.
	SnowballServiceID                     = "snowball"                     // Snowball.
	SnsServiceID                          = "sns"                          // Sns.
	SqsServiceID                          = "sqs"                          // Sqs.
	SsmServiceID                          = "ssm"                          // Ssm.
	StatesServiceID                       = "states"                       // States.
	StoragegatewayServiceID               = "storagegateway"               // Storagegateway.
	StreamsDynamodbServiceID              = "streams.dynamodb"             // StreamsDynamodb.
	StsServiceID                          = "sts"                          // Sts.
	SupportServiceID                      = "support"                      // Support.
	SwfServiceID                          = "swf"                          // Swf.
	TaggingServiceID                      = "tagging"                      // Tagging.
	TranslateServiceID                    = "translate"                    // Translate.
	WafServiceID                          = "waf"                          // Waf.
	WafRegionalServiceID                  = "waf-regional"                 // WafRegional.
	WorkdocsServiceID                     = "workdocs"                     // Workdocs.
	WorkmailServiceID                     = "workmail"                     // Workmail.
	WorkspacesServiceID                   = "workspaces"                   // Workspaces.
	XrayServiceID                         = "xray"                         // Xray.
)

// DefaultResolver returns an Endpoint resolver that will be able
// to resolve endpoints for: AWS Standard, AWS China, and AWS GovCloud (US).
//
// Use DefaultPartitions() to get the list of the default partitions.
func DefaultResolver() Resolver {
	return defaultPartitions
}

// DefaultPartitions returns a list of the partitions the SDK is bundled
// with. The available partitions are: AWS Standard, AWS China, and AWS GovCloud (US).
//
//    partitions := endpoints.DefaultPartitions
//    for _, p := range partitions {
//        // ... inspect partitions
//    }
func DefaultPartitions() []Partition {
	return defaultPartitions.Partitions()
}

var defaultPartitions = partitions{
	awsPartition,
	awscnPartition,
	awsusgovPartition,
}

// AwsPartition returns the Resolver for AWS Standard.
func AwsPartition() Partition {
	return awsPartition.Partition()
}

var awsPartition = partition{
	ID:        "aws",
	Name:      "AWS Standard",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^(us|eu|ap|sa|ca)\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"ap-northeast-1": region{
			Description: "Asia Pacific (Tokyo)",
		},
		"ap-northeast-2": region{
			Description: "Asia Pacific (Seoul)",
		},
		"ap-south-1": region{
			Description: "Asia Pacific (Mumbai)",
		},
		"ap-southeast-1": region{
			Description: "Asia Pacific (Singapore)",
		},
		"ap-southeast-2": region{
			Description: "Asia Pacific (Sydney)",
		},
		"ca-central-1": region{
			Description: "Canada (Central)",
		},
		"eu-central-1": region{
			Description: "EU (Frankfurt)",
		},
		"eu-west-1": region{
			Description: "EU (Ireland)",
		},
		"eu-west-2": region{
			Description: "EU (London)",
		},
		"eu-west-3": region{
			Description: "EU (Paris)",
		},
		"sa-east-1": region{
			Description: "South America (Sao Paulo)",
		},
		"us-east-1": region{
			Description: "US East (N. Virginia)",
		},
		"us-east-2": region{
			Description: "US East (Ohio)",
		},
		"us-west-1": region{
			Description: "US West (N. California)",
		},
		"us-west-2": region{
			Description: "US West (Oregon)",
		},
	},
	Services: services{
		"a4b": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"acm": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"acm-pca": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"api.mediatailor": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
			},
		},
		"api.pricing": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "pricing",
				},
			},
			Endpoints: endpoints{
				"ap-south-1": endpoint{},
				"us-east-1":  endpoint{},
			},
		},
		"api.sagemaker": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"apigateway": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpoint{
				Hostname:  "autoscaling.{region}.amazonaws.com",
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "application-autoscaling",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"appstream2": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
				CredentialScope: credentialScope{
					Service: "appstream",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"appsync": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"athena": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"autoscaling-plans": service{
			Defaults: endpoint{
				Hostname:  "autoscaling.{region}.amazonaws.com",
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "autoscaling-plans",
				},
			},
			Endpoints: endpoints{
				"ap-southeast-1": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"batch": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"budgets": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "budgets.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"ce": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "ce.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"chime": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,
			Defaults: endpoint{
				SSLCommonName: "service.chime.aws.amazon.com",
				Protocols:     []string{"https"},
			},
			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:  "service.chime.aws.amazon.com",
					Protocols: []string{"https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cloud9": service{

			Endpoints: endpoints{
				"ap-southeast-1": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"clouddirectory": service{

			Endpoints: endpoints{
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudfront": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:  "cloudfront.amazonaws.com",
					Protocols: []string{"http", "https"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"cloudhsm": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "cloudhsm",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudsearch": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"codebuild": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "codebuild-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "codebuild-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "codebuild-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "codebuild-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"codecommit": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips": endpoint{
					Hostname: "codecommit-fips.ca-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ca-central-1",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "codedeploy-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "codedeploy-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "codedeploy-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "codedeploy-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"codepipeline": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"codestar": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cognito-identity": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cognito-idp": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cognito-sync": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"comprehend": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"cur": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"datapipeline": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"dax": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"devicefarm": service{

			Endpoints: endpoints{
				"us-west-2": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"discovery": service{

			Endpoints: endpoints{
				"us-west-2": endpoint{},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"ds": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"local": endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"ec2metadata": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:  "169.254.169.254/latest",
					Protocols: []string{"http"},
				},
			},
		},
		"ecr": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips": endpoint{
					Hostname: "elasticache-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"elasticbeanstalk": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"elasticfilesystem": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpoint{
				SSLCommonName: "{region}.{service}.{dnsSuffix}",
				Protocols:     []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1": endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				"eu-west-1": endpoint{},
				"eu-west-2": endpoint{},
				"eu-west-3": endpoint{},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{
					SSLCommonName: "{service}.{region}.{dnsSuffix}",
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"elastictranscoder": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"email": service{

			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"entitlement.marketplace": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "aws-marketplace",
				},
			},
			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"firehose": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"fms": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"gamelift": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"glue": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"greengrass": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"health": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "iam.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"importexport": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:          "importexport.amazonaws.com",
					SignatureVersions: []string{"v2", "v4"},
					CredentialScope: credentialScope{
						Region:  "us-east-1",
						Service: "IngestionService",
					},
				},
			},
		},
		"inspector": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"iot": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "execute-api",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"iotanalytics": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"kinesisanalytics": service{

			Endpoints: endpoints{
				"eu-central-1": endpoint{},
				"eu-west-1":    endpoint{},
				"us-east-1":    endpoint{},
				"us-west-2":    endpoint{},
			},
		},
		"kinesisvideo": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"kms": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"lightsail": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"machinelearning": service{

			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
			},
		},
		"marketplacecommerceanalytics": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"mediaconvert": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"medialive": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mediapackage": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mediastore": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"metering.marketplace": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "aws-marketplace",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mgh": service{

			Endpoints: endpoints{
				"us-west-2": endpoint{},
			},
		},
		"mobileanalytics": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"models.lex": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "lex",
				},
			},
			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"monitoring": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"mturk-requester": service{
			IsRegionalized: boxedFalse,

			Endpoints: endpoints{
				"sandbox": endpoint{
					Hostname: "mturk-requester-sandbox.us-east-1.amazonaws.com",
				},
				"us-east-1": endpoint{},
			},
		},
		"neptune": service{

			Endpoints: endpoints{
				"eu-central-1": endpoint{
					Hostname: "rds.eu-central-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-central-1",
					},
				},
				"eu-west-1": endpoint{
					Hostname: "rds.eu-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-1",
					},
				},
				"eu-west-2": endpoint{
					Hostname: "rds.eu-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "eu-west-2",
					},
				},
				"us-east-1": endpoint{
					Hostname: "rds.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{
					Hostname: "rds.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-2": endpoint{
					Hostname: "rds.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"opsworks": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"opsworks-cm": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"organizations": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "organizations.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"pinpoint": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "mobiletargeting",
				},
			},
			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
			},
		},
		"polly": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1": endpoint{
					SSLCommonName: "{service}.{dnsSuffix}",
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"rekognition": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"resource-groups": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"route53": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "route53.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"route53domains": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"runtime.lex": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "lex",
				},
			},
			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"runtime.sagemaker": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"s3": service{
			PartitionEndpoint: "us-east-1",
			IsRegionalized:    boxedTrue,
			Defaults: endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"s3v4"},

				HasDualStack:      boxedTrue,
				DualStackHostname: "{service}.dualstack.{region}.{dnsSuffix}",
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Hostname:          "s3.ap-northeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{
					Hostname:          "s3.ap-southeast-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"ap-southeast-2": endpoint{
					Hostname:          "s3.ap-southeast-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"ca-central-1": endpoint{},
				"eu-central-1": endpoint{},
				"eu-west-1": endpoint{
					Hostname:          "s3.eu-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"eu-west-2": endpoint{},
				"eu-west-3": endpoint{},
				"s3-external-1": endpoint{
					Hostname:          "s3-external-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"sa-east-1": endpoint{
					Hostname:          "s3.sa-east-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"us-east-1": endpoint{
					Hostname:          "s3.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{
					Hostname:          "s3.us-west-1.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
				"us-west-2": endpoint{
					Hostname:          "s3.us-west-2.amazonaws.com",
					SignatureVersions: []string{"s3", "s3v4"},
				},
			},
		},
		"sdb": service{
			Defaults: endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"v2"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1": endpoint{
					Hostname: "sdb.amazonaws.com",
				},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"secretsmanager": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "secretsmanager-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "secretsmanager-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "secretsmanager-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "secretsmanager-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"serverlessrepo": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{
					Protocols: []string{"https"},
				},
				"ap-northeast-2": endpoint{
					Protocols: []string{"https"},
				},
				"ap-south-1": endpoint{
					Protocols: []string{"https"},
				},
				"ap-southeast-1": endpoint{
					Protocols: []string{"https"},
				},
				"ap-southeast-2": endpoint{
					Protocols: []string{"https"},
				},
				"ca-central-1": endpoint{
					Protocols: []string{"https"},
				},
				"eu-central-1": endpoint{
					Protocols: []string{"https"},
				},
				"eu-west-1": endpoint{
					Protocols: []string{"https"},
				},
				"eu-west-2": endpoint{
					Protocols: []string{"https"},
				},
				"sa-east-1": endpoint{
					Protocols: []string{"https"},
				},
				"us-east-1": endpoint{
					Protocols: []string{"https"},
				},
				"us-east-2": endpoint{
					Protocols: []string{"https"},
				},
				"us-west-1": endpoint{
					Protocols: []string{"https"},
				},
				"us-west-2": endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"servicecatalog": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "servicecatalog-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "servicecatalog-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "servicecatalog-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "servicecatalog-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"servicediscovery": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"shield": service{
			IsRegionalized: boxedFalse,
			Defaults: endpoint{
				SSLCommonName: "Shield.us-east-1.amazonaws.com",
				Protocols:     []string{"https"},
			},
			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"sms": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"sns": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpoint{
				SSLCommonName: "{region}.queue.{dnsSuffix}",
				Protocols:     []string{"http", "https"},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"fips-us-east-1": endpoint{
					Hostname: "sqs-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"fips-us-east-2": endpoint{
					Hostname: "sqs-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"fips-us-west-1": endpoint{
					Hostname: "sqs-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"fips-us-west-2": endpoint{
					Hostname: "sqs-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{
					SSLCommonName: "queue.{dnsSuffix}",
				},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"states": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"storagegateway": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"local": endpoint{
					Hostname:  "localhost:8000",
					Protocols: []string{"http"},
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"sa-east-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-2": endpoint{},
				"us-west-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"sts": service{
			PartitionEndpoint: "aws-global",
			Defaults: endpoint{
				Hostname: "sts.amazonaws.com",
				CredentialScope: credentialScope{
					Region: "us-east-1",
				},
			},
			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{
					Hostname: "sts.ap-northeast-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "ap-northeast-2",
					},
				},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"aws-global":     endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "sts-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "sts-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-1": endpoint{},
				"us-west-1-fips": endpoint{
					Hostname: "sts-fips.us-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-1",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "sts-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"support": service{

			Endpoints: endpoints{
				"us-east-1": endpoint{},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"tagging": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"translate": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
				"us-east-1-fips": endpoint{
					Hostname: "translate-fips.us-east-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
				"us-east-2": endpoint{},
				"us-east-2-fips": endpoint{
					Hostname: "translate-fips.us-east-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-2",
					},
				},
				"us-west-2": endpoint{},
				"us-west-2-fips": endpoint{
					Hostname: "translate-fips.us-west-2.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-west-2",
					},
				},
			},
		},
		"waf": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname: "waf.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-east-1",
					},
				},
			},
		},
		"waf-regional": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"workdocs": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"eu-west-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"workmail": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"eu-west-1": endpoint{},
				"us-east-1": endpoint{},
				"us-west-2": endpoint{},
			},
		},
		"workspaces": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
		"xray": service{

			Endpoints: endpoints{
				"ap-northeast-1": endpoint{},
				"ap-northeast-2": endpoint{},
				"ap-south-1":     endpoint{},
				"ap-southeast-1": endpoint{},
				"ap-southeast-2": endpoint{},
				"ca-central-1":   endpoint{},
				"eu-central-1":   endpoint{},
				"eu-west-1":      endpoint{},
				"eu-west-2":      endpoint{},
				"eu-west-3":      endpoint{},
				"sa-east-1":      endpoint{},
				"us-east-1":      endpoint{},
				"us-east-2":      endpoint{},
				"us-west-1":      endpoint{},
				"us-west-2":      endpoint{},
			},
		},
	},
}

// AwsCnPartition returns the Resolver for AWS China.
func AwsCnPartition() Partition {
	return awscnPartition.Partition()
}

var awscnPartition = partition{
	ID:        "aws-cn",
	Name:      "AWS China",
	DNSSuffix: "amazonaws.com.cn",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^cn\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"cn-north-1": region{
			Description: "China (Beijing)",
		},
		"cn-northwest-1": region{
			Description: "China (Ningxia)",
		},
	},
	Services: services{
		"apigateway": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"application-autoscaling": service{
			Defaults: endpoint{
				Hostname:  "autoscaling.{region}.amazonaws.com.cn",
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "application-autoscaling",
				},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"autoscaling": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"codebuild": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"cognito-identity": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ds": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ec2": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ec2metadata": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:  "169.254.169.254/latest",
					Protocols: []string{"http"},
				},
			},
		},
		"ecr": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticbeanstalk": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticloadbalancing": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"elasticmapreduce": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"glacier": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-cn-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-cn-global": endpoint{
					Hostname: "iam.cn-north-1.amazonaws.com.cn",
					CredentialScope: credentialScope{
						Region: "cn-north-1",
					},
				},
			},
		},
		"iot": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "execute-api",
				},
			},
			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"monitoring": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"s3": service{
			Defaults: endpoint{
				Protocols:         []string{"http", "https"},
				SignatureVersions: []string{"s3v4"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"sms": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"sns": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"sqs": service{
			Defaults: endpoint{
				SSLCommonName: "{region}.queue.{dnsSuffix}",
				Protocols:     []string{"http", "https"},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"storagegateway": service{

			Endpoints: endpoints{
				"cn-north-1": endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				Protocols: []string{"http", "https"},
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"sts": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
		"tagging": service{

			Endpoints: endpoints{
				"cn-north-1":     endpoint{},
				"cn-northwest-1": endpoint{},
			},
		},
	},
}

// AwsUsGovPartition returns the Resolver for AWS GovCloud (US).
func AwsUsGovPartition() Partition {
	return awsusgovPartition.Partition()
}

var awsusgovPartition = partition{
	ID:        "aws-us-gov",
	Name:      "AWS GovCloud (US)",
	DNSSuffix: "amazonaws.com",
	RegionRegex: regionRegex{
		Regexp: func() *regexp.Regexp {
			reg, _ := regexp.Compile("^us\\-gov\\-\\w+\\-\\d+$")
			return reg
		}(),
	},
	Defaults: endpoint{
		Hostname:          "{service}.{region}.{dnsSuffix}",
		Protocols:         []string{"https"},
		SignatureVersions: []string{"v4"},
	},
	Regions: regions{
		"us-gov-west-1": region{
			Description: "AWS GovCloud (US)",
		},
	},
	Services: services{
		"acm": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"api.sagemaker": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"apigateway": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"application-autoscaling": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"autoscaling": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"clouddirectory": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"cloudformation": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"cloudhsm": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"cloudhsmv2": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "cloudhsm",
				},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"cloudtrail": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"codedeploy": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "codedeploy-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"config": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"directconnect": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"dms": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"dynamodb": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"ec2": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"ec2metadata": service{
			PartitionEndpoint: "aws-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-global": endpoint{
					Hostname:  "169.254.169.254/latest",
					Protocols: []string{"http"},
				},
			},
		},
		"ecr": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"ecs": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"elasticache": service{

			Endpoints: endpoints{
				"fips": endpoint{
					Hostname: "elasticache-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{},
			},
		},
		"elasticbeanstalk": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"elasticloadbalancing": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"elasticmapreduce": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					Protocols: []string{"https"},
				},
			},
		},
		"es": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"events": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"glacier": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"guardduty": service{
			IsRegionalized: boxedTrue,
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"iam": service{
			PartitionEndpoint: "aws-us-gov-global",
			IsRegionalized:    boxedFalse,

			Endpoints: endpoints{
				"aws-us-gov-global": endpoint{
					Hostname: "iam.us-gov.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"inspector": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"iot": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "execute-api",
				},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"kinesis": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"kms": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"lambda": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"logs": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"metering.marketplace": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "aws-marketplace",
				},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"monitoring": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"polly": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"rds": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"redshift": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"rekognition": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"runtime.sagemaker": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"s3": service{
			Defaults: endpoint{
				SignatureVersions: []string{"s3", "s3v4"},
			},
			Endpoints: endpoints{
				"fips-us-gov-west-1": endpoint{
					Hostname: "s3-fips-us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
				"us-gov-west-1": endpoint{
					Hostname:  "s3.us-gov-west-1.amazonaws.com",
					Protocols: []string{"http", "https"},
				},
			},
		},
		"sms": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"snowball": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"sns": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					Protocols: []string{"http", "https"},
				},
			},
		},
		"sqs": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{
					SSLCommonName: "{region}.queue.{dnsSuffix}",
					Protocols:     []string{"http", "https"},
				},
			},
		},
		"ssm": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"states": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"storagegateway": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"streams.dynamodb": service{
			Defaults: endpoint{
				CredentialScope: credentialScope{
					Service: "dynamodb",
				},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "dynamodb.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
		"sts": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"swf": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"tagging": service{

			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
			},
		},
		"translate": service{
			Defaults: endpoint{
				Protocols: []string{"https"},
			},
			Endpoints: endpoints{
				"us-gov-west-1": endpoint{},
				"us-gov-west-1-fips": endpoint{
					Hostname: "translate-fips.us-gov-west-1.amazonaws.com",
					CredentialScope: credentialScope{
						Region: "us-gov-west-1",
					},
				},
			},
		},
	},
}
