#!/bin/bash

function root__ecs() {
  if [ "${1-}" == "help" ]; then
    echo "Run ECS related commands"
    exit 0
  fi
  process_build ecs__ $@
}

function ecs__random_ip() {
  if [ "${1-}" == "help" ]; then
    echo "Returns an arbitrary IP of a service inside a cluster"
    exit 0
  fi
  DEPLOY="${1-}"
  if [ -z ${DEPLOY} ]; then
    echo "Pick a valid deploy.  Valid deploy:"
    echo
    print_valid_infra_deploy
    exit 1
  fi
  infra_assume_infra_role ${DEPLOY}
  if ! cluster_name=$(cached_cloudformation_output "${SERVICE}:${DEPLOY}:deploy:ECSCluster"); then
    echo "Unable to find cluster name"
    echo ${cluster_name}
    return 1
  fi
  if ! service_name=$(cached_cloudformation_output "${SERVICE}:${DEPLOY}:deploy:ECSService"); then
    echo "Unable to find service name"
    echo ${cluster_name}
    return 1
  fi

  # With a cluster name and service name, find a task
  if ! TASK_ARN=$(aws ecs list-tasks --cluster ${cluster_name} --service-name ${service_name} --query 'taskArns[0]' --output text); then
    echo "Unable to find task arn for ${service_name} and "${cluster_name}
    echo ${TASK_ARN}
    return 1
  fi

  # Now with the task use some query magic to find the task's IP
  PRIVATE_IP=$(aws ecs describe-tasks --tasks "${TASK_ARN}" --cluster "${cluster_name}" --query "tasks[0].attachments[?type=='ElasticNetworkInterface'] | [0].details[?name=='privateIPv4Address'].value | [0]" --output text)
  echo ${PRIVATE_IP}
}

function ecs__go_dump_profile() {
  # Note: could not figure out how to run this inside docker
  if [ "${1-}" == "help" ]; then
    echo "Dump the go profile of a host using the socks proxy.  -p [allocs|goroutines|profile|...].  Requires go >= 1.11"
    exit 0
  fi

  # Allocs generates faster
  PROFILE="allocs"
  while getopts ":p:" opt; do
    case ${opt} in
      p)
        PROFILE=${OPTARG}
        ;;
      \?)
        echo "Invalid option: -$OPTARG" >&2
        return 1
        ;;
    esac
  done
  shift "$((OPTIND-1))"

  if ! IP=$(DEBUG=false make_run builder run ecs random_ip $@ | tr -d '\r'); then
    echo "Unable to find profile IP"
    echo ${IP}
    return 1
  fi

  PROFILE_FILE="${TMPDIR-/tmp}/profile"
  curl -x socks5h://${socks_addr-localhost:4456} "${IP}:6060/debug/pprof/${PROFILE}" > ${PROFILE_FILE}

  # We could run this inside the
  go tool pprof -http :9090 ${PROFILE_FILE}
}
