#!/bin/bash

OPS_PREFIX=${OPS_PREFIX-search-discovery/servicecreation/development}

function root__sandstorm() {
  if [ "${1-}" == "help" ]; then
    echo "Fetch secrets from sandstorm"
    exit 0
  fi
  process_build sandstorm__ $@
}

function sandstorm__ops() {
  if [ "${1-}" == "help" ]; then
    echo "Fetch an ops secret from sandstorm"
    exit 0
  fi
  if [ "${USE_BUILDER}" == "true" ]; then
    make_exec builder run sandstorm ops $@
  fi
  if [ -z "${1-}" ]; then
    echo "Pass in a secret to fetch"
    exit 1
  fi
  ops_sandstorm $@
}

function ops_sandstorm() {
  (
    infra_assume_bootstrap_role pipeline
    sandstorm-cli get --role-arn ${OPS_SECRETS_ARN} ${OPS_PREFIX}/${1}
  )
}
