#!/bin/bash

OPS_PREFIX=${OPS_PREFIX-search-discovery/servicecreation/development}

function root__terraform() {
  if [[ "${1-}" == "help" ]]; then
    echo "Run terraform commands"
    exit 0
  fi
  process_build terraform__ $@
}

function terraform__apply() {
  if [[ "${1-}" == "help" ]]; then
    echo "Apply the ops terraform"
    exit 0
  fi
  make_run twinit enable || true
  if [[ "${USE_BUILDER}" == "true" ]]; then
    USE_TWINIT=true make_exec builder run terraform apply $@
  fi
  (
    cd terraform
    infra_assume_bootstrap_role pipeline
    # Use -get-plugins=false to enforce that we are vendoring the plugins we need inside the builder
    terraform init -get-plugins=false
    GRAFANA_AUTH=$(ops_sandstorm grafana-key) PAGERDUTY_TOKEN=$(ops_sandstorm pagerduty) terraform apply
  )
}

function terraform__format() {
  if [[ "${1-}" == "help" ]]; then
    echo "Format all terraform files"
    exit 0
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    make_exec builder run terraform format $@
  fi
  (
    cd terraform
    terraform fmt
  )
}
