package events

import (
	"time"

	"code.justin.tv/sse/malachai/pkg/config"
)

// Config holds configuration options for EventLogger
type Config struct {
	Environment string

	// how often the logger will send batched logs to firehose
	ReportInterval time.Duration

	// optional. if 0, buffer is unlimited
	BufferSizeLimit int64

	putRecordBatchRecordLimit int
	putRecordBatchSizeLimit   int

	firehoseDeliveryStreamName string
	firehoseRegion             string
	firehoseRoleArn            string
}

func (cfg *Config) fillDefaults() (err error) {
	if cfg.Environment == "" {
		cfg.Environment = "production"
	}

	res, err := config.GetResources(cfg.Environment)
	if err != nil {
		return
	}

	if cfg.firehoseDeliveryStreamName == "" {
		cfg.firehoseDeliveryStreamName = res.FirehoseDeliveryStreamName
	}

	if cfg.firehoseRoleArn == "" {
		cfg.firehoseRoleArn = res.FirehoseLoggerRoleArn
	}

	if cfg.firehoseRegion == "" {
		cfg.firehoseRegion = res.Region
	}

	if cfg.firehoseDeliveryStreamName == "" {
		cfg.firehoseDeliveryStreamName = res.FirehoseDeliveryStreamName
	}

	if cfg.ReportInterval == 0 {
		cfg.ReportInterval = DefaultReportInterval
	}
	return
}
