package events

import (
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/firehose"

	"code.justin.tv/sse/malachai/pkg/config"
	"code.justin.tv/sse/malachai/pkg/internal/closer"
	"code.justin.tv/sse/malachai/pkg/log"
)

// NewEventLogger constructs an in memory event logger
func NewEventLogger(cfg Config, logger log.S2SLogger) (client *Client, err error) {
	err = cfg.fillDefaults()
	if err != nil {
		return
	}

	sess, err := session.NewSession(config.AWSConfig(cfg.firehoseRegion, cfg.firehoseRoleArn))
	if err != nil {
		return
	}

	batcher := &FirehoseBatcher{
		BatchCount:                 cfg.putRecordBatchRecordLimit,
		MaxSize:                    cfg.putRecordBatchSizeLimit,
		FirehoseDeliveryStreamName: cfg.firehoseDeliveryStreamName,
		Firehose:                   firehose.New(sess),
	}
	client = &Client{
		Buffer: &memoryEventBuffer{
			bufferLimit: cfg.BufferSizeLimit,
			closer:      closer.New(),
			logger:      logger,
		},
		FirehoseBatcher: batcher,
		ReportInterval:  cfg.ReportInterval,
		Logger:          logger,
	}
	return
}
