package api

import (
	"time"

	"code.justin.tv/feeds/service-common"
	"code.justin.tv/vod/vinyl/client"
	"code.justin.tv/web/channel-audits/client"

	"goji.io"
	"goji.io/pat"
)

const gracefulShutdownWindow = 1 * time.Second

type HTTPService struct {
	service_common.BaseHTTPServer

	Vinyl         vinyl.Client
	ChannelAudits channel_audits.Client
}

func (s *HTTPService) LegendRoutes(mux *goji.Mux) {
	mux.Handle(pat.Get("/v1/legend/:user_id"), s.CreateHandler("get_legend", s.getLegend))
}
