module "bs-prod" {
  source                           = "../modules/tf_beanstalk_webserver_env"
  aws_profile                      = "twitch-feed-aws"
  eb_application_name              = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id                           = "vpc-29b8fe4d"
  ec2_subnet_ids                   = "subnet-118b5d49,subnet-e588ff81,subnet-814ac4f7"
  elb_subnet_ids                   = "subnet-118b5d49,subnet-e588ff81,subnet-814ac4f7"
  elb_loadbalancer_security_groups = "sg-5c05723a"
  auto_scaling_lc_security_groups  = "sg-5c05723a"
  solution_stack_name              = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_instance_type    = "t2.micro"
  owner                            = "feeds@twitch.tv"
  service                          = "feeds/legend"
  env                              = "prod"
  associate_public_address         = "false"
  xray_role                        = "arn:aws:iam::641044725657:role/foundation-xray-role"
}
