module "bs-staging" {
  source                           = "../modules/tf_beanstalk_webserver_env"
  aws_profile                      = "twitch-feed-dev"
  eb_application_name              = "${module.bs-app-staging.beanstalk_application_name}"
  vpc_id                           = "vpc-5bb8fe3f"
  ec2_subnet_ids                   = "subnet-9f4ac4e9,subnet-0b88ff6f,subnet-658b5d3d"
  elb_subnet_ids                   = "subnet-9f4ac4e9,subnet-0b88ff6f,subnet-658b5d3d"
  elb_loadbalancer_security_groups = "sg-71057217"
  auto_scaling_lc_security_groups  = "sg-71057217"
  solution_stack_name              = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_instance_type    = "t2.micro"
  owner                            = "feeds@twitch.tv"
  service                          = "feeds/legend"
  env                              = "staging"
  associate_public_address         = "false"
  xray_role                        =  "arn:aws:iam::465369119046:role/foundation-xray-role"

  env_message = "hello staging"
}
