package masonry

import (
	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/errors"
	"code.justin.tv/feeds/service-common/feedcache/gorediscache"
	"github.com/go-redis/redis"
)

type RedisConfig struct {
	gorediscache.GoredisConfig
	addr *distconf.Str
}

// ClusterOptions gets a redis cluster setup that points to the correct Addrs
func (m *RedisConfig) ClusterOptions() *redis.ClusterOptions {
	// Note: We don't update the address if it changes.  The client currently does not support this.
	//       To pick up those changes, we will need to restart the service.
	return &redis.ClusterOptions{
		Addrs: []string{m.addr.Get()},
	}
}

// Load RedisCacheConfig from distconf
func (m *RedisConfig) Load(dconf *distconf.Distconf) error {
	m.addr = dconf.Str("masonry.redis.addr", "")

	if m.addr.Get() == "" {
		return errors.New("unable to find masonry.redis.addr")
	}
	return m.GoredisConfig.Verify("masonry.redis", dconf)
}
