package models

import (
	"time"

	"code.justin.tv/feeds/clients/feeddataflow"
	"code.justin.tv/feeds/feeds-common/entity"
	"code.justin.tv/feeds/feeds-common/verb"
)

// ActivityBatch is the batch of stories that are sent out of fanout service
type ActivityBatch struct {
	Activities []*Activity            `json:"activities"`
	FeedIDs    []string               `json:"feed_ids"`
	Metadata   *feeddataflow.Metadata `json:"metadata,omitempty"`
}

// Activity is the feed object that comes into fanout service
type Activity struct {
	Entity entity.Entity `json:"entity"`
	Verb   verb.Verb     `json:"verb"`
	Actor  entity.Entity `json:"actor"`

	RecGenerationID    string                 `json:"rec_generation_id,omitempty"`
	RecGenerationIndex *int                   `json:"rec_generation_index,omitempty"`
	RelevanceReason    *RelevanceReason       `json:"relevance_reason,omitempty"`
	Metadata           *feeddataflow.Metadata `json:"metadata,omitempty"`
}

// A Feed is a collection of Activity items that you can paginate through using the cursor
type Feed struct {
	ID       string        `json:"id"`
	Cursor   string        `json:"cursor"`
	Items    []*Activity   `json:"items"`
	Tracking *FeedTracking `json:"tracking,omitempty"`
}

// FeedTracking holds feed level tracking information
type FeedTracking struct {
	BatchID string `json:"batch_id,omitempty"`
}

// A Story is everything stored in a row in the database
type Story struct {
	FeedID    string    `json:"feed_id"`
	StoryID   string    `json:"story_id"`
	Activity  Activity  `json:"activity"`
	Score     float64   `json:"score"`
	UpdatedAt time.Time `json:"updated_at"`
}

// RelevanceReason describes why an Activity is being added to a feed.
type RelevanceReason struct {
	// Kind is a keyword that identifies the reason.
	Kind string `json:"kind"`

	// Source identifies the service or component that created this reason.
	Source string `json:"source"`

	// EntityID identifies who or what the reason relates to.  For example, the EntityID for a followed_channel
	// reason would be the channel ID of the channel that was followed.
	EntityID string `json:"entity_id,omitempty"`
}
