package ranker

import (
	"strings"

	"golang.org/x/net/context"
)

// ChannelFeed is how we rank items on the channel feed page
type ChannelFeed struct {
	Ranker
}

var _ FeedTypeRanker = &ChannelFeed{}

// ShouldRank returns true if s begins with 'c:' (is channel feed ID)
func (c *ChannelFeed) ShouldRank(s string) bool {
	return strings.HasPrefix(s, "c:")
}

// LoadStory returns a story that uses the entity ID as the story ID
func (c *ChannelFeed) LoadStory(ctx context.Context, a *Activity) *Story {
	return &Story{
		Activity: a,
		StoryID:  a.Entity.Encode(),
	}
}
