package ranker

import (
	"strings"

	"code.justin.tv/feeds/feeds-common/entity"
	"golang.org/x/net/context"
)

// FeedTraitLoader loads traits for any feed
type FeedTraitLoader struct {
}

// ForFeed loads FeedTraits for a feed ID
func (f *FeedTraitLoader) ForFeed(ctx context.Context, feedID string) (*FeedTraits, error) {
	if strings.HasPrefix(feedID, "c:") {
		return &FeedTraits{
			Owner:    entity.New(entity.NamespaceUser, feedID[2:]),
			FeedType: Channel,
		}, nil
	}
	if strings.HasPrefix(feedID, "n:") {
		return &FeedTraits{
			Owner:    entity.New(entity.NamespaceUser, feedID[2:]),
			FeedType: News,
		}, nil
	}
	return &FeedTraits{
		FeedType: Unknown,
	}, nil
}
