package ranker

import (
	"strings"

	"golang.org/x/net/context"
)

// NewsFeed is how we rank news feed items
type NewsFeed struct {
	Ranker
}

var _ FeedTypeRanker = &NewsFeed{}

// ShouldRank returns true if the feed is a news feed
func (c *NewsFeed) ShouldRank(s string) bool {
	return strings.HasPrefix(s, "n:")
}

// LoadStory uses the entity ID as the story ID
func (c *NewsFeed) LoadStory(ctx context.Context, a *Activity) *Story {
	return &Story{
		Activity: a,
		StoryID:  a.Entity.Encode(),
	}
}
