package ranker

import (
	"math/rand"
	"sync"

	"golang.org/x/net/context"
)

// RandRanker randomly assigns ranks
type RandRanker struct {
	mu   sync.Mutex
	Rand *rand.Rand
}

var _ Ranker = &RandRanker{}

// Score returns a random float
func (r *RandRanker) Score(ctx context.Context, ab *ActivityBatch) (RankedActivity, error) {
	r.mu.Lock()
	defer r.mu.Unlock()
	var ret RankedActivity
	for _, activity := range ab.Activities {
		for _, feedID := range ab.FeedIDs {
			ret.storeScore(activity, feedID, activity.Entity.Encode(), r.Rand.Float64())
		}
	}
	return ret, nil
}
