package ranker

import "golang.org/x/net/context"

// FeedTypeRanker is any feed item ranker that knows which feeds it should rank
type FeedTypeRanker interface {
	Ranker
	ShouldRank(string) bool
}

// RankSplitter can split ranking between different types of feed.
type RankSplitter struct {
	RankerList []FeedTypeRanker
}

// Score will split activity by feed type, rank each of them, and return a cumulative batch
func (rs *RankSplitter) Score(ctx context.Context, ab *ActivityBatch) (RankedActivity, error) {
	batchSets := make([]ActivityBatch, len(rs.RankerList))
	for batchSetIdx := range batchSets {
		batchSets[batchSetIdx] = ActivityBatch{
			Metadata:   ab.Metadata,
			Activities: ab.Activities,
		}
	}
	for _, feedID := range ab.FeedIDs {
	rankerLoop:
		for rankerIndex, rankPair := range rs.RankerList {
			if rankPair.ShouldRank(feedID) {
				batchSets[rankerIndex].FeedIDs = append(batchSets[rankerIndex].FeedIDs, feedID)
				break rankerLoop
			}
		}
	}
	rankerList := make([]RankedActivity, 0, len(batchSets))
	for batchIdx, batchSet := range batchSets {
		if len(batchSet.FeedIDs) == 0 {
			continue
		}
		rankedActivity, err := rs.RankerList[batchIdx].Score(ctx, &batchSet)
		if err != nil {
			return RankedActivity{}, err
		}
		rankerList = append(rankerList, rankedActivity)
	}
	var ret RankedActivity
	for _, rankedActivity := range rankerList {
		ret.merge(rankedActivity)
	}
	return ret, nil
}
