package mocks

import (
	"golang.org/x/net/context"

	"code.justin.tv/discovery/recommendations/client"
	"code.justin.tv/foundation/twitchclient"
	"github.com/stretchr/testify/mock"
)

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// GetFavoriteChannels provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetFavoriteChannels(ctx context.Context, params *recommendations.GetFavoriteChannelsParams, reqOpts *twitchclient.ReqOpts) ([]string, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetFavoriteChannelsParams, *twitchclient.ReqOpts) []string); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetFavoriteChannelsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetFavoriteGames provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetFavoriteGames(ctx context.Context, params *recommendations.GetFavoriteGamesParams, reqOpts *twitchclient.ReqOpts) ([]string, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetFavoriteGamesParams, *twitchclient.ReqOpts) []string); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetFavoriteGamesParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetOnboardingChannels provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetOnboardingChannels(ctx context.Context, params *recommendations.GetOnboardingChannelsParams, reqOpts *twitchclient.ReqOpts) (*recommendations.OnboardingChannels, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 *recommendations.OnboardingChannels
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetOnboardingChannelsParams, *twitchclient.ReqOpts) *recommendations.OnboardingChannels); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.OnboardingChannels)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetOnboardingChannelsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRealtimeClips provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetRealtimeClips(ctx context.Context, params *recommendations.GetRealtimeClipsParams, reqOpts *twitchclient.ReqOpts) ([]recommendations.RealtimeClip, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []recommendations.RealtimeClip
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetRealtimeClipsParams, *twitchclient.ReqOpts) []recommendations.RealtimeClip); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]recommendations.RealtimeClip)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetRealtimeClipsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRecommendations provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetRecommendations(ctx context.Context, params *recommendations.GetRecommendationsParams, reqOpts *twitchclient.ReqOpts) (*recommendations.Recommendations, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 *recommendations.Recommendations
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetRecommendationsParams, *twitchclient.ReqOpts) *recommendations.Recommendations); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.Recommendations)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetRecommendationsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRecommendationsForDevice provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetRecommendationsForDevice(ctx context.Context, params *recommendations.GetRecommendationsForDeviceParams, reqOpts *twitchclient.ReqOpts) (*recommendations.VodIDs, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 *recommendations.VodIDs
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetRecommendationsForDeviceParams, *twitchclient.ReqOpts) *recommendations.VodIDs); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.VodIDs)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetRecommendationsForDeviceParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRecommendationsForUser provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetRecommendationsForUser(ctx context.Context, params *recommendations.GetRecommendationsForUserParams, reqOpts *twitchclient.ReqOpts) (*recommendations.VodIDs, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 *recommendations.VodIDs
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetRecommendationsForUserParams, *twitchclient.ReqOpts) *recommendations.VodIDs); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.VodIDs)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetRecommendationsForUserParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRecommendedStreams provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetRecommendedStreams(ctx context.Context, params *recommendations.GetRecommendedStreamsParams, reqOpts *twitchclient.ReqOpts) ([]recommendations.SimilarStreams, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []recommendations.SimilarStreams
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetRecommendedStreamsParams, *twitchclient.ReqOpts) []recommendations.SimilarStreams); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]recommendations.SimilarStreams)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetRecommendedStreamsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSimilarChannels provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetSimilarChannels(ctx context.Context, params *recommendations.GetSimilarChannelsParams, reqOpts *twitchclient.ReqOpts) ([]string, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetSimilarChannelsParams, *twitchclient.ReqOpts) []string); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetSimilarChannelsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSimilarClips provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetSimilarClips(ctx context.Context, params *recommendations.GetSimilarClipsParams, reqOpts *twitchclient.ReqOpts) ([]string, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetSimilarClipsParams, *twitchclient.ReqOpts) []string); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetSimilarClipsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSimilarVideos provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetSimilarVideos(ctx context.Context, params *recommendations.GetSimilarVideosParams, reqOpts *twitchclient.ReqOpts) ([]string, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetSimilarVideosParams, *twitchclient.ReqOpts) []string); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetSimilarVideosParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSocialRecommendationsForUser provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetSocialRecommendationsForUser(ctx context.Context, params *recommendations.GetSocialRecommendationsForUserParams, reqOpts *twitchclient.ReqOpts) (*recommendations.SocialRecommendedStreamList, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 *recommendations.SocialRecommendedStreamList
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetSocialRecommendationsForUserParams, *twitchclient.ReqOpts) *recommendations.SocialRecommendedStreamList); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.SocialRecommendedStreamList)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetSocialRecommendationsForUserParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTrending provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetTrending(ctx context.Context, params *recommendations.GetTrendingParams, reqOpts *twitchclient.ReqOpts) (*recommendations.Videos, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 *recommendations.Videos
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetTrendingParams, *twitchclient.ReqOpts) *recommendations.Videos); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.Videos)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetTrendingParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUnfilteredFavoriteChannels provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetUnfilteredFavoriteChannels(ctx context.Context, params *recommendations.GetUnfilteredFavoriteChannelsParams, reqOpts *twitchclient.ReqOpts) ([]string, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 []string
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetUnfilteredFavoriteChannelsParams, *twitchclient.ReqOpts) []string); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetUnfilteredFavoriteChannelsParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetVodRecommendationsForDevice provides a mock function with given fields: ctx, params, reqOpts
func (_m *Client) GetVodRecommendationsForDevice(ctx context.Context, params *recommendations.GetVodRecommendationsForDeviceParams, reqOpts *twitchclient.ReqOpts) (*recommendations.RecommendedVodIDs, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 *recommendations.RecommendedVodIDs
	if rf, ok := ret.Get(0).(func(context.Context, *recommendations.GetVodRecommendationsForDeviceParams, *twitchclient.ReqOpts) *recommendations.RecommendedVodIDs); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.RecommendedVodIDs)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *recommendations.GetVodRecommendationsForDeviceParams, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// HasRecommendedStreams provides a mock function with given fields: ctx, channelID, reqOpts
func (_m *Client) HasRecommendedStreams(ctx context.Context, channelID string, reqOpts *twitchclient.ReqOpts) (*recommendations.RecommendedStreamsMetadata, error) {
	ret := _m.Called(ctx, channelID, reqOpts)

	var r0 *recommendations.RecommendedStreamsMetadata
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchclient.ReqOpts) *recommendations.RecommendedStreamsMetadata); ok {
		r0 = rf(ctx, channelID, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*recommendations.RecommendedStreamsMetadata)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, channelID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
