package recommendations

import "time"

type cachedObject struct {
	RecGenerationID string           `json:"rec_generation_id"`
	Recommendations []Recommendation `json:"recommendations"`
	FetchTime       time.Time        `json:"fetch_time"`

	// Offset is where inside Recommendations we should pull recs from
	Offset int64 `json:"offset"`
	// NumServed is the deepest into recommendations that we've gone
	NumServed int `json:"num_served"`
	ttl       time.Duration
}

func (t *cachedObject) CacheTTL() time.Duration {
	return t.ttl
}

type recResult struct {
	RecGenerationID string           `json:"rec_generation_id"`
	RecRequestID    string           `json:"rec_request_id"`
	Recommendations []Recommendation `json:"recommendations"`
}

// Recommendation is a single recommended story from the recs service, cached into redis
type Recommendation struct {
	Type string `json:"type"`
	ID   string `json:"id"`

	Reason             RecommendationReason `json:"rec_reason,omitempty"`
	RecGenerationID    string               `json:"rec_generation_id,omitempty"`
	RecGenerationIndex *int                 `json:"rec_generation_index,omitempty"`
	Score              float64              `json:"-"`
}

// RecommendationReason describes why this recommendation was created for a user
type RecommendationReason struct {
	Kind      string `json:"kind"`
	ContextID string `json:"context_id,omitempty"`
}

// RecommendationResponse includes a list of recs and a cursor for the next call
type RecommendationResponse struct {
	Recs    []Recommendation
	Cursor  string
	BatchID string
}

// StoryID creates the masonry story identifier for a recommendation
func (r *Recommendation) StoryID() string {
	return r.Type + ":" + r.ID
}
