locals {
  service = "masonry"

  sandstorm_role_arns = {
    integration = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-integration"
    staging     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-staging"
    canary      = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
    production  = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/feeds-production"
  }

  sandstorm_role_arn = "${lookup(local.sandstorm_role_arns, var.environment)}"
}

variable environment {}
variable iam_id {}
variable rec_feed_arn {}
variable story_feed_arn {}

resource "aws_iam_role_policy" "sandstorm_policy" {
  name = "${local.service}_${var.environment}_sandstorm"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Resource": [
        "${local.sandstorm_role_arn}"
      ],
      "Effect": "Allow"
    }
  ]
}
EOF
}

// Note: Need the '*' because the index and the table have different ARN values
resource "aws_iam_role_policy" "policy" {
  name = "${local.service}_${var.environment}_policy"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "dynamodb:*"
      ],
      "Resource": [
        "${var.rec_feed_arn}*",
        "${var.story_feed_arn}*"
      ]
    }
  ]
}
EOF
}

# TODO: Find a way to limit this to just the SQS queue we care about
resource "aws_iam_role_policy" "sqs_policy" {
  name = "sqs_policy_${local.service}_${var.environment}"
  role = "${var.iam_id}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "Stmt1471373292000",
            "Effect": "Allow",
            "Action": [
                "sqs:DeleteMessage",
                "sqs:ReceiveMessage",
                "sqs:SendMessage"
            ],
            "Resource": [
                "*"
            ]
        }
    ]
}
EOF
}
