# Friendship

[![GoDoc](https://godoc.internal.justin.tv/code.justin.tv/chat/friendship?status.png)](http://godoc.internal.justin.tv/code.justin.tv/chat/friendship)
[![codecov](https://codecov.internal.justin.tv/ghe/chat/friendship/branch/master/graph/badge.svg)](https://codecov.internal.justin.tv/ghe/chat/friendship)

Don't be lonely on Twitch.

## API
Friendship has a minimal but growing Twirp API. If you can get what you need using Twirp, you should. [GoDocs here][1].

Non-Twirp API documentation:
- [Kraken API Documentation](https://git-aws.internal.justin.tv/chat/friendship/blob/master/docs/api.md)
- [Pubsub API Documentation](https://git-aws.internal.justin.tv/chat/friendship/blob/master/docs/pubsub.md)
- [Backend API Spec](https://docs.google.com/document/d/1IhbPQAKtwouqco6MTJVGkUUVkeD4J8LlovISQbA9l3Y)

[1]: https://godoc.internal.justin.tv/code.justin.tv/chat/friendship/rpc/friends

## Service Information

The Friendship service uses [Cohesion](https://git-aws.internal.justin.tv/web/cohesion) as a datastore to hold the friendship relationships.
It also communicates with other services such as Rails for auxiliary information and authentication.

Relevant documentation:
[Technical Spec](https://docs.google.com/document/d/1VV1bj5p1hbXQnr_YQHXQR2W7mcXGTbNRr8bdXQN0_Nc/edit#) (other specs are linked from here),
[Cohesion Design](https://docs.google.com/document/d/1um8sHSD4lX0UUqciHriJUhhX8mIUfbA5jnePY-Qx-0Y/edit#)

## Environments

- Staging host:	`https://friendship-staging.internal.twitch.tv`
- Production host: `https://friendship.internal.twitch.tv`

## Integration Tests

See [here](integration_tests/README.md).

## Local Development

### Running

First, install Go

    brew install go --cross-compile-common

Now set up your $GOPATH

    mkdir $HOME/go
    export GOPATH=$HOME/go

Download the repo into it

    go get -d code.justin.tv/chat/friendship
    cd ~/go/src/code.justin.tv/chat/friendship

Install runtime dependencies:

    make setup

Run Foreman for Friendship:

    foreman start

### Development
#### Mocks
If you modify interfaces, you may need to regenerate mocks. You can do that with

    make mocks

#### Adding or Updating a Dependency
To add or update a dependency, add it to glide.yaml and set (or update) the SHA to what you want, then run

    make glide

#### Manually Testing Twirp Endpoints
You should write automated tests for any new Twirp endpoints, but if you need to test it manually as well, you can use a
request like the following to interact with the autogenerated JSON version of the endpoint.
```http
curl -X POST \
  -H 'Content-Type: application/json' \
  localhost:8000/twirp/code.justin.tv.chat.friendship.Friends/GetIncomingFriendRequests \
  -d '{"user_id": "29798286"}'
```
(replacing "GetIncomingFriendRequests" with the endpoint you're trying to test)
