package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/golibs/gojiplus"
)

func (s *Server) acceptRequestV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id", "friend_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	callerID := params[0] // User who is accepting a friend.
	targetID := params[1] // Accepted user.

	if err := s.backend.AcceptRequest(ctx, callerID, targetID); err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}
	w.WriteHeader(http.StatusNoContent)
}
