package api

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"

	"code.justin.tv/chat/friendship/app/backend"
	"code.justin.tv/chat/friendship/app/backend/backendtest"
	"code.justin.tv/chat/redis"
)

func TestAcceptRequestV0WhileLocked(t *testing.T) {
	s, b := serverWithTestBackend(t)

	mockRedis := b.Redis.(*redis.MockRedis)
	defer mockRedis.AssertExpectations(t)
	mockRedis.On("DistLock", mock.Anything, fmt.Sprintf("all_relationships:%s,%s", backend.BobID, backend.AliceID), mock.Anything).
		Return(false, nil)

	mockFriends := b.Friends.(*backendtest.CohesionClient)
	assert.Zero(t, len(mockFriends.GetCalls()))

	path := fmt.Sprintf("/users/%s/friends/%s", backend.AliceID, backend.BobID)
	w := doTestHTTP(t, s, "PUT", path)

	assert.Equal(t, w.Result().StatusCode, 409)
}
