package api

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"

	"code.justin.tv/chat/friendship/app/backend"
	"code.justin.tv/chat/friendship/rpc/friends"
	"code.justin.tv/chat/redis"
)

func TestClearUnreadCount(t *testing.T) {
	t.Run("should succeed", func(t *testing.T) {
		server, b := serverWithTestBackend(t)

		req := friends.ClearUnreadCountReq{
			UserId: backend.AliceID,
		}

		mockRedis := b.Redis.(*redis.MockRedis)
		mockRedis.On("Del", mock.Anything, []string{"incoming_request:" + backend.AliceID}).Return(1, nil).Once()

		_, err := server.ClearUnreadCount(context.Background(), &req)

		assert.NoError(t, err)
	})
}
