package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/golibs/gojiplus"
)

func (s *Server) deleteFriendshipV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id", "friend_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	callerID := params[0] // User who is deleting a friend.
	targetID := params[1] // Deleted friend.

	if err := s.backend.RemoveFriend(ctx, callerID, targetID); err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}

	w.WriteHeader(http.StatusNoContent)
}

func (s *Server) deleteUserV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	sourceID := params[0] // User who is deleting a friend.

	if err := s.backend.DeleteUser(ctx, sourceID); err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
