package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/golibs/gojiplus"
)

// isFamiliar checks if user_id is an acquaintance to target_id and is defined
// by certain criteria. See the list of criteria in /app/backend/familiar.go.
// NOTE: isFamiliar is NOT a symmetric relationship!
//
// Callers may customize which criteria to check for with query params:
//  ?criteria=is_friend&criteria=is_follower&criteria=is_mod
func (s *Server) isFamiliarV1(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id", "target_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	sourceID := params[0]
	targetID := params[1]

	q := r.URL.Query()
	reason, isFamiliar := s.backend.IsFamiliar(ctx, sourceID, targetID, q["criteria"])

	gojiplus.ServeJSON(w, r, responses.IsFamiliarResponse{
		Reason:     reason,
		IsFamiliar: isFamiliar,
	})
}
