package api

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/chat/friendship/app/backend"
	"code.justin.tv/chat/friendship/app/backend/backendtest"
	"code.justin.tv/chat/friendship/rpc/friends"
)

func TestGetFriendships(t *testing.T) {
	t.Run("should succeed", func(t *testing.T) {

		server, b := serverWithTestBackend(t)
		mockFriends := b.Friends.(*backendtest.CohesionClient)

		req := friends.GetFriendshipsReq{
			UserId: backend.AliceID,
		}

		resp, err := server.GetFriendships(context.Background(), &req)

		assert.Equal(t, resp.Total, int64(0))
		assert.NoError(t, err)

		assert.Equal(t, 2, len(mockFriends.GetCalls()))

		calls := mockFriends.GetCalls()
		listCall := calls[0]
		expected := backendtest.Call{
			Name:       "ListAssoc",
			E1:         backend.AliceID,
			Kind:       backend.FriendsWith,
			EntityKind: backend.User,
		}
		validateCall(t, listCall, expected)

		countCall := calls[1]
		expected = backendtest.Call{
			Name:       "CountAssoc",
			E1:         backend.AliceID,
			Kind:       backend.FriendsWith,
			EntityKind: backend.User,
		}
		validateCall(t, countCall, expected)
	})
}
